/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.action;

import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.spi.ElementSelector;
import ch.qos.logback.core.joran.spi.SaxEventInterpretationContext;
import ch.qos.logback.core.util.OptionHelper;
import org.xml.sax.Attributes;

public class NewRuleAction
extends Action {
    boolean inError = false;

    @Override
    public void begin(SaxEventInterpretationContext ec, String localName, Attributes attributes2) {
        this.inError = false;
        String pattern2 = attributes2.getValue("pattern");
        String actionClass = attributes2.getValue("actionClass");
        if (OptionHelper.isNullOrEmptyOrAllSpaces(pattern2)) {
            this.inError = true;
            String errorMsg = "No 'pattern' attribute in <newRule>";
            this.addError(errorMsg);
            return;
        }
        if (OptionHelper.isNullOrEmptyOrAllSpaces(actionClass)) {
            this.inError = true;
            String errorMsg = "No 'actionClass' attribute in <newRule>";
            this.addError(errorMsg);
            return;
        }
        try {
            this.addInfo("About to add new Joran parsing rule [" + pattern2 + "," + actionClass + "].");
            ec.getSaxEventInterpreter().getRuleStore().addRule(new ElementSelector(pattern2), actionClass);
        }
        catch (Exception oops) {
            this.inError = true;
            String errorMsg = "Could not add new Joran parsing rule [" + pattern2 + "," + actionClass + "]";
            this.addError(errorMsg);
        }
    }

    @Override
    public void end(SaxEventInterpretationContext ec, String n) {
    }

    public void finish(SaxEventInterpretationContext ec) {
    }
}

