/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model.processor;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.model.ResourceModel;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.spi.ContextAwarePropertyContainer;
import ch.qos.logback.core.util.Loader;
import ch.qos.logback.core.util.OptionHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;

public abstract class ResourceHandlerBase
extends ModelHandlerBase {
    protected String attributeInUse;
    protected boolean optional;

    protected ResourceHandlerBase(Context context) {
        super(context);
    }

    protected InputStream openURL(URL url2) {
        try {
            return url2.openStream();
        }
        catch (IOException e2) {
            this.warnIfRequired("Failed to open [" + url2.toString() + "]");
            return null;
        }
    }

    protected boolean checkAttributes(ResourceModel resourceModel) {
        String fileAttribute = resourceModel.getFile();
        String urlAttribute = resourceModel.getUrl();
        String resourceAttribute = resourceModel.getResource();
        int count2 = 0;
        if (!OptionHelper.isNullOrEmptyOrAllSpaces(fileAttribute)) {
            ++count2;
        }
        if (!OptionHelper.isNullOrEmptyOrAllSpaces(urlAttribute)) {
            ++count2;
        }
        if (!OptionHelper.isNullOrEmptyOrAllSpaces(resourceAttribute)) {
            ++count2;
        }
        if (count2 == 0) {
            this.addError("One of \"path\", \"resource\" or \"url\" attributes must be set.");
            return false;
        }
        if (count2 > 1) {
            this.addError("Only one of \"file\", \"url\" or \"resource\" attributes should be set.");
            return false;
        }
        if (count2 == 1) {
            return true;
        }
        throw new IllegalStateException("Count value [" + count2 + "] is not expected");
    }

    protected String getAttribureInUse() {
        return this.attributeInUse;
    }

    protected URL getInputURL(ContextAwarePropertyContainer contextAwarePropertyContainer, ResourceModel resourceModel) {
        String fileAttribute = resourceModel.getFile();
        String urlAttribute = resourceModel.getUrl();
        String resourceAttribute = resourceModel.getResource();
        if (!OptionHelper.isNullOrEmptyOrAllSpaces(fileAttribute)) {
            this.attributeInUse = contextAwarePropertyContainer.subst(fileAttribute);
            return this.filePathAsURL(this.attributeInUse);
        }
        if (!OptionHelper.isNullOrEmptyOrAllSpaces(urlAttribute)) {
            this.attributeInUse = contextAwarePropertyContainer.subst(urlAttribute);
            return this.attributeToURL(this.attributeInUse);
        }
        if (!OptionHelper.isNullOrEmptyOrAllSpaces(resourceAttribute)) {
            this.attributeInUse = contextAwarePropertyContainer.subst(resourceAttribute);
            return this.resourceAsURL(this.attributeInUse);
        }
        throw new IllegalStateException("A URL stream should have been returned at this stage");
    }

    protected URL filePathAsURL(String path2) {
        URI uri2 = new File(path2).toURI();
        try {
            return uri2.toURL();
        }
        catch (MalformedURLException e2) {
            e2.printStackTrace();
            return null;
        }
    }

    protected URL attributeToURL(String urlAttribute) {
        try {
            return new URL(urlAttribute);
        }
        catch (MalformedURLException mue) {
            String errMsg = "URL [" + urlAttribute + "] is not well formed.";
            this.addError(errMsg, mue);
            return null;
        }
    }

    protected URL resourceAsURL(String resourceAttribute) {
        URL url2 = Loader.getResourceBySelfClassLoader(resourceAttribute);
        if (url2 == null) {
            this.warnIfRequired("Could not find resource corresponding to [" + resourceAttribute + "]");
            return null;
        }
        return url2;
    }

    protected void warnIfRequired(String msg) {
        if (!this.optional) {
            this.addWarn(msg);
        }
    }
}

