/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.pattern.CompositeConverter;
import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.DynamicConverter;
import ch.qos.logback.core.spi.ContextAware;

public class ConverterUtil {
    public static <E> void startConverters(Converter<E> head2) {
        for (Converter<E> c2 = head2; c2 != null; c2 = c2.getNext()) {
            if (c2 instanceof CompositeConverter) {
                CompositeConverter cc = (CompositeConverter)c2;
                Converter childConverter = cc.childConverter;
                ConverterUtil.startConverters(childConverter);
                cc.start();
                continue;
            }
            if (!(c2 instanceof DynamicConverter)) continue;
            DynamicConverter dc = (DynamicConverter)c2;
            dc.start();
        }
    }

    public static <E> Converter<E> findTail(Converter<E> head2) {
        Converter<E> next2;
        Converter<E> p = head2;
        while (p != null && (next2 = p.getNext()) != null) {
            p = next2;
        }
        return p;
    }

    public static <E> void setContextForConverters(Context context, Converter<E> head2) {
        for (Converter<E> c2 = head2; c2 != null; c2 = c2.getNext()) {
            if (c2 instanceof ContextAware) {
                ((ContextAware)((Object)c2)).setContext(context);
            }
            if (!(c2 instanceof CompositeConverter)) continue;
            CompositeConverter cc = (CompositeConverter)c2;
            Converter childConverter = cc.childConverter;
            ConverterUtil.setContextForConverters(context, childConverter);
        }
    }
}

