/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern.util;

import ch.qos.logback.core.pattern.util.IEscapeUtil;

public class RegularEscapeUtil
implements IEscapeUtil {
    @Override
    public void escape(String escapeChars, StringBuffer buf, char next2, int pointer) {
        if (escapeChars.indexOf(next2) >= 0) {
            buf.append(next2);
        } else {
            switch (next2) {
                case '_': {
                    break;
                }
                case '\\': {
                    buf.append(next2);
                    break;
                }
                case 't': {
                    buf.append('\t');
                    break;
                }
                case 'r': {
                    buf.append('\r');
                    break;
                }
                case 'n': {
                    buf.append('\n');
                    break;
                }
                default: {
                    String commaSeperatedEscapeChars = this.formatEscapeCharsForListing(escapeChars);
                    throw new IllegalArgumentException("Illegal char '" + next2 + " at column " + pointer + ". Only \\\\, \\_" + commaSeperatedEscapeChars + ", \\t, \\n, \\r combinations are allowed as escape characters.");
                }
            }
        }
    }

    String formatEscapeCharsForListing(String escapeChars) {
        StringBuilder commaSeperatedEscapeChars = new StringBuilder();
        for (int i2 = 0; i2 < escapeChars.length(); ++i2) {
            commaSeperatedEscapeChars.append(", \\").append(escapeChars.charAt(i2));
        }
        return commaSeperatedEscapeChars.toString();
    }

    public static String basicEscape(String s2) {
        int len2 = s2.length();
        StringBuilder sbuf = new StringBuilder(len2);
        int i2 = 0;
        while (i2 < len2) {
            int c2;
            if ((c2 = s2.charAt(i2++)) == 92 && i2 < len2) {
                if ((c2 = s2.charAt(i2++)) == 110) {
                    c2 = 10;
                } else if (c2 == 114) {
                    c2 = 13;
                } else if (c2 == 116) {
                    c2 = 9;
                } else if (c2 == 102) {
                    c2 = 12;
                } else if (c2 == 8) {
                    c2 = 8;
                } else if (c2 == 34) {
                    c2 = 34;
                } else if (c2 == 39) {
                    c2 = 39;
                } else if (c2 == 92) {
                    c2 = 92;
                }
            }
            sbuf.append((char)c2);
        }
        return sbuf.toString();
    }
}

