/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.ConverterUtil;
import ch.qos.logback.core.pattern.DynamicConverter;
import ch.qos.logback.core.pattern.LiteralConverter;
import ch.qos.logback.core.pattern.parser.Node;
import ch.qos.logback.core.pattern.parser.Parser;
import ch.qos.logback.core.pattern.util.AlmostAsIsEscapeUtil;
import ch.qos.logback.core.rolling.helper.DateTokenConverter;
import ch.qos.logback.core.rolling.helper.FileFilterUtil;
import ch.qos.logback.core.rolling.helper.IntegerTokenConverter;
import ch.qos.logback.core.rolling.helper.MonoTypedConverter;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.ScanException;
import java.time.Instant;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class FileNamePattern
extends ContextAwareBase {
    static final Map<String, Supplier<DynamicConverter>> CONVERTER_MAP = new HashMap<String, Supplier<DynamicConverter>>();
    String pattern;
    Converter<Object> headTokenConverter;

    public FileNamePattern(String patternArg, Context contextArg) {
        this.setPattern(FileFilterUtil.slashify(patternArg));
        this.setContext(contextArg);
        this.parse();
        ConverterUtil.startConverters(this.headTokenConverter);
    }

    void parse() {
        try {
            String patternForParsing = this.escapeRightParantesis(this.pattern);
            Parser p = new Parser(patternForParsing, new AlmostAsIsEscapeUtil());
            p.setContext(this.context);
            Node t2 = p.parse();
            this.headTokenConverter = p.compile(t2, CONVERTER_MAP);
        }
        catch (ScanException sce) {
            this.addError("Failed to parse pattern \"" + this.pattern + "\".", sce);
        }
    }

    String escapeRightParantesis(String in) {
        return this.pattern.replace(")", "\\)");
    }

    public String toString() {
        return this.pattern;
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.pattern == null ? 0 : this.pattern.hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileNamePattern other = (FileNamePattern)obj;
        return !(this.pattern == null ? other.pattern != null : !this.pattern.equals(other.pattern));
    }

    public DateTokenConverter<Object> getPrimaryDateTokenConverter() {
        for (Converter<Object> p = this.headTokenConverter; p != null; p = p.getNext()) {
            DateTokenConverter dtc;
            if (!(p instanceof DateTokenConverter) || !(dtc = (DateTokenConverter)p).isPrimary()) continue;
            return dtc;
        }
        return null;
    }

    public IntegerTokenConverter getIntegerTokenConverter() {
        for (Converter<Object> p = this.headTokenConverter; p != null; p = p.getNext()) {
            if (!(p instanceof IntegerTokenConverter)) continue;
            return (IntegerTokenConverter)p;
        }
        return null;
    }

    public boolean hasIntegerTokenCOnverter() {
        IntegerTokenConverter itc = this.getIntegerTokenConverter();
        return itc != null;
    }

    public String convertMultipleArguments(Object ... objectList) {
        StringBuilder buf = new StringBuilder();
        for (Converter<Object> c2 = this.headTokenConverter; c2 != null; c2 = c2.getNext()) {
            if (c2 instanceof MonoTypedConverter) {
                MonoTypedConverter monoTyped = (MonoTypedConverter)((Object)c2);
                for (Object o : objectList) {
                    if (!monoTyped.isApplicable(o)) continue;
                    buf.append(c2.convert(o));
                }
                continue;
            }
            buf.append(c2.convert(objectList));
        }
        return buf.toString();
    }

    public String convert(Object o) {
        StringBuilder buf = new StringBuilder();
        for (Converter<Object> p = this.headTokenConverter; p != null; p = p.getNext()) {
            buf.append(p.convert(o));
        }
        return buf.toString();
    }

    public String convertInt(int i2) {
        return this.convert(i2);
    }

    public void setPattern(String pattern2) {
        if (pattern2 != null) {
            this.pattern = pattern2.trim();
        }
    }

    public String getPattern() {
        return this.pattern;
    }

    public String toRegexForFixedDate(Date date) {
        StringBuilder buf = new StringBuilder();
        for (Converter<Object> p = this.headTokenConverter; p != null; p = p.getNext()) {
            if (p instanceof LiteralConverter) {
                buf.append(p.convert(null));
                continue;
            }
            if (p instanceof IntegerTokenConverter) {
                buf.append("(\\d+)");
                continue;
            }
            if (!(p instanceof DateTokenConverter)) continue;
            buf.append(p.convert(date));
        }
        return buf.toString();
    }

    public String toRegexForFixedDate(Instant instant) {
        StringBuilder buf = new StringBuilder();
        for (Converter<Object> p = this.headTokenConverter; p != null; p = p.getNext()) {
            if (p instanceof LiteralConverter) {
                buf.append(p.convert(null));
                continue;
            }
            if (p instanceof IntegerTokenConverter) {
                buf.append("(\\d+)");
                continue;
            }
            if (!(p instanceof DateTokenConverter)) continue;
            buf.append(p.convert(instant));
        }
        return buf.toString();
    }

    public String toRegex() {
        StringBuilder buf = new StringBuilder();
        for (Converter<Object> p = this.headTokenConverter; p != null; p = p.getNext()) {
            if (p instanceof LiteralConverter) {
                buf.append(p.convert(null));
                continue;
            }
            if (p instanceof IntegerTokenConverter) {
                buf.append("\\d+");
                continue;
            }
            if (!(p instanceof DateTokenConverter)) continue;
            DateTokenConverter dtc = (DateTokenConverter)p;
            buf.append(dtc.toRegex());
        }
        return buf.toString();
    }

    static {
        CONVERTER_MAP.put("i", IntegerTokenConverter::new);
        CONVERTER_MAP.put("d", DateTokenConverter::new);
    }
}

