/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.util.Loader;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;

public class LocationUtil {
    public static final String SCHEME_PATTERN = "^\\p{Alpha}[\\p{Alnum}+.-]*:.*$";
    public static final String CLASSPATH_SCHEME = "classpath:";

    public static URL urlForResource(String location) throws MalformedURLException, FileNotFoundException {
        if (location == null) {
            throw new NullPointerException("location is required");
        }
        URL url2 = null;
        if (!location.matches(SCHEME_PATTERN)) {
            url2 = Loader.getResourceBySelfClassLoader(location);
        } else if (location.startsWith(CLASSPATH_SCHEME)) {
            String path2 = location.substring(CLASSPATH_SCHEME.length());
            if (path2.startsWith("/")) {
                path2 = path2.substring(1);
            }
            if (path2.length() == 0) {
                throw new MalformedURLException("path is required");
            }
            url2 = Loader.getResourceBySelfClassLoader(path2);
        } else {
            url2 = new URL(location);
        }
        if (url2 == null) {
            throw new FileNotFoundException(location);
        }
        return url2;
    }
}

