/*
 * Decompiled with CFR 0.152.
 */
package com.ezylang.evalex;

import com.ezylang.evalex.EvaluationException;
import com.ezylang.evalex.config.ExpressionConfiguration;
import com.ezylang.evalex.data.DataAccessorIfc;
import com.ezylang.evalex.data.EvaluationValue;
import com.ezylang.evalex.functions.FunctionIfc;
import com.ezylang.evalex.operators.OperatorIfc;
import com.ezylang.evalex.parser.ASTNode;
import com.ezylang.evalex.parser.ParseException;
import com.ezylang.evalex.parser.ShuntingYardConverter;
import com.ezylang.evalex.parser.Token;
import com.ezylang.evalex.parser.Tokenizer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import lombok.Generated;

public class Expression {
    private final ExpressionConfiguration configuration;
    private final String expressionString;
    private final DataAccessorIfc dataAccessor;
    private final Map<String, EvaluationValue> constants = new TreeMap<String, EvaluationValue>(String.CASE_INSENSITIVE_ORDER);
    private ASTNode abstractSyntaxTree;

    public Expression(String expressionString) {
        this(expressionString, ExpressionConfiguration.defaultConfiguration());
    }

    public Expression(String expressionString, ExpressionConfiguration configuration) {
        this.expressionString = expressionString;
        this.configuration = configuration;
        this.dataAccessor = configuration.getDataAccessorSupplier().get();
        this.constants.putAll(configuration.getDefaultConstants());
    }

    public Expression(Expression expression) throws ParseException {
        this(expression.getExpressionString(), expression.getConfiguration());
        this.abstractSyntaxTree = expression.getAbstractSyntaxTree();
    }

    public EvaluationValue evaluate() throws EvaluationException, ParseException {
        EvaluationValue result2 = this.evaluateSubtree(this.getAbstractSyntaxTree());
        if (result2.isNumberValue()) {
            BigDecimal bigDecimal = result2.getNumberValue();
            if (this.configuration.getDecimalPlacesResult() != -1) {
                bigDecimal = this.roundValue(bigDecimal, this.configuration.getDecimalPlacesResult());
            }
            if (this.configuration.isStripTrailingZeros()) {
                bigDecimal = bigDecimal.stripTrailingZeros();
            }
            result2 = EvaluationValue.numberValue(bigDecimal);
        }
        return result2;
    }

    public EvaluationValue evaluateSubtree(ASTNode startNode) throws EvaluationException {
        EvaluationValue result2;
        Token token2 = startNode.getToken();
        switch (token2.getType()) {
            case NUMBER_LITERAL: {
                result2 = EvaluationValue.numberOfString(token2.getValue(), this.configuration.getMathContext());
                break;
            }
            case STRING_LITERAL: {
                result2 = EvaluationValue.stringValue(token2.getValue());
                break;
            }
            case VARIABLE_OR_CONSTANT: {
                result2 = this.getVariableOrConstant(token2);
                if (!result2.isExpressionNode()) break;
                result2 = this.evaluateSubtree(result2.getExpressionNode());
                break;
            }
            case PREFIX_OPERATOR: 
            case POSTFIX_OPERATOR: {
                result2 = token2.getOperatorDefinition().evaluate(this, token2, this.evaluateSubtree(startNode.getParameters().get(0)));
                break;
            }
            case INFIX_OPERATOR: {
                result2 = this.evaluateInfixOperator(startNode, token2);
                break;
            }
            case ARRAY_INDEX: {
                result2 = this.evaluateArrayIndex(startNode);
                break;
            }
            case STRUCTURE_SEPARATOR: {
                result2 = this.evaluateStructureSeparator(startNode);
                break;
            }
            case FUNCTION: {
                result2 = this.evaluateFunction(startNode, token2);
                break;
            }
            default: {
                throw new EvaluationException(token2, "Unexpected evaluation token: " + String.valueOf(token2));
            }
        }
        if (result2.isNumberValue() && this.configuration.getDecimalPlacesRounding() != -1) {
            return EvaluationValue.numberValue(this.roundValue(result2.getNumberValue(), this.configuration.getDecimalPlacesRounding()));
        }
        return result2;
    }

    private EvaluationValue getVariableOrConstant(Token token2) throws EvaluationException {
        EvaluationValue result2 = this.constants.get(token2.getValue());
        if (result2 == null) {
            result2 = this.getDataAccessor().getData(token2.getValue());
        }
        if (result2 == null) {
            throw new EvaluationException(token2, String.format("Variable or constant value for '%s' not found", token2.getValue()));
        }
        return result2;
    }

    private EvaluationValue evaluateFunction(ASTNode startNode, Token token2) throws EvaluationException {
        ArrayList<EvaluationValue> parameterResults = new ArrayList<EvaluationValue>();
        for (int i2 = 0; i2 < startNode.getParameters().size(); ++i2) {
            if (token2.getFunctionDefinition().isParameterLazy(i2)) {
                parameterResults.add(this.convertValue(startNode.getParameters().get(i2)));
                continue;
            }
            parameterResults.add(this.evaluateSubtree(startNode.getParameters().get(i2)));
        }
        EvaluationValue[] parameters2 = parameterResults.toArray(new EvaluationValue[0]);
        FunctionIfc function = token2.getFunctionDefinition();
        function.validatePreEvaluation(token2, parameters2);
        return function.evaluate(this, token2, parameters2);
    }

    private EvaluationValue evaluateArrayIndex(ASTNode startNode) throws EvaluationException {
        EvaluationValue array = this.evaluateSubtree(startNode.getParameters().get(0));
        EvaluationValue index = this.evaluateSubtree(startNode.getParameters().get(1));
        if (array.isArrayValue() && index.isNumberValue()) {
            if (index.getNumberValue().intValue() < 0 || index.getNumberValue().intValue() >= array.getArrayValue().size()) {
                throw new EvaluationException(startNode.getToken(), String.format("Index %d out of bounds for array of length %d", index.getNumberValue().intValue(), array.getArrayValue().size()));
            }
            return array.getArrayValue().get(index.getNumberValue().intValue());
        }
        throw EvaluationException.ofUnsupportedDataTypeInOperation(startNode.getToken());
    }

    private EvaluationValue evaluateStructureSeparator(ASTNode startNode) throws EvaluationException {
        EvaluationValue structure = this.evaluateSubtree(startNode.getParameters().get(0));
        Token nameToken = startNode.getParameters().get(1).getToken();
        String name = nameToken.getValue();
        if (structure.isStructureValue()) {
            if (!structure.getStructureValue().containsKey(name)) {
                throw new EvaluationException(nameToken, String.format("Field '%s' not found in structure", name));
            }
            return structure.getStructureValue().get(name);
        }
        throw EvaluationException.ofUnsupportedDataTypeInOperation(startNode.getToken());
    }

    private EvaluationValue evaluateInfixOperator(ASTNode startNode, Token token2) throws EvaluationException {
        EvaluationValue right;
        EvaluationValue left;
        OperatorIfc op = token2.getOperatorDefinition();
        if (op.isOperandLazy()) {
            left = this.convertValue(startNode.getParameters().get(0));
            right = this.convertValue(startNode.getParameters().get(1));
        } else {
            left = this.evaluateSubtree(startNode.getParameters().get(0));
            right = this.evaluateSubtree(startNode.getParameters().get(1));
        }
        return op.evaluate(this, token2, left, right);
    }

    private BigDecimal roundValue(BigDecimal value2, int decimalPlaces) {
        value2 = value2.setScale(decimalPlaces, this.configuration.getMathContext().getRoundingMode());
        return value2;
    }

    public ASTNode getAbstractSyntaxTree() throws ParseException {
        if (this.abstractSyntaxTree == null) {
            Tokenizer tokenizer = new Tokenizer(this.expressionString, this.configuration);
            ShuntingYardConverter converter = new ShuntingYardConverter(this.expressionString, tokenizer.parse(), this.configuration);
            this.abstractSyntaxTree = converter.toAbstractSyntaxTree();
        }
        return this.abstractSyntaxTree;
    }

    public void validate() throws ParseException {
        this.getAbstractSyntaxTree();
    }

    public Expression with(String variable, Object value2) {
        if (this.constants.containsKey(variable)) {
            if (this.configuration.isAllowOverwriteConstants()) {
                this.constants.remove(variable);
            } else {
                throw new UnsupportedOperationException(String.format("Can't set value for constant '%s'", variable));
            }
        }
        this.getDataAccessor().setData(variable, this.convertValue(value2));
        return this;
    }

    public Expression and(String variable, Object value2) {
        return this.with(variable, value2);
    }

    public Expression withValues(Map<String, ?> values2) {
        for (Map.Entry<String, ?> entry : values2.entrySet()) {
            this.with(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public Expression copy() throws ParseException {
        return new Expression(this);
    }

    public ASTNode createExpressionNode(String expression) throws ParseException {
        Tokenizer tokenizer = new Tokenizer(expression, this.configuration);
        ShuntingYardConverter converter = new ShuntingYardConverter(expression, tokenizer.parse(), this.configuration);
        return converter.toAbstractSyntaxTree();
    }

    public EvaluationValue convertDoubleValue(double value2) {
        return this.convertValue(value2);
    }

    public EvaluationValue convertValue(Object value2) {
        return EvaluationValue.of(value2, this.configuration);
    }

    public List<ASTNode> getAllASTNodes() throws ParseException {
        return this.getAllASTNodesForNode(this.getAbstractSyntaxTree());
    }

    private List<ASTNode> getAllASTNodesForNode(ASTNode node) {
        ArrayList<ASTNode> nodes2 = new ArrayList<ASTNode>();
        nodes2.add(node);
        for (ASTNode child : node.getParameters()) {
            nodes2.addAll(this.getAllASTNodesForNode(child));
        }
        return nodes2;
    }

    public Set<String> getUsedVariables() throws ParseException {
        TreeSet<String> variables = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (ASTNode node : this.getAllASTNodes()) {
            if (node.getToken().getType() != Token.TokenType.VARIABLE_OR_CONSTANT || this.constants.containsKey(node.getToken().getValue())) continue;
            variables.add(node.getToken().getValue());
        }
        return variables;
    }

    public Set<String> getUndefinedVariables() throws ParseException {
        TreeSet<String> variables = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (String variable : this.getUsedVariables()) {
            if (this.getDataAccessor().getData(variable) != null) continue;
            variables.add(variable);
        }
        return variables;
    }

    @Generated
    public ExpressionConfiguration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public String getExpressionString() {
        return this.expressionString;
    }

    @Generated
    public DataAccessorIfc getDataAccessor() {
        return this.dataAccessor;
    }

    @Generated
    public Map<String, EvaluationValue> getConstants() {
        return this.constants;
    }
}

