/*
 * Decompiled with CFR 0.152.
 */
package com.ezylang.evalex.data.conversion;

import com.ezylang.evalex.config.ExpressionConfiguration;
import com.ezylang.evalex.data.EvaluationValue;
import com.ezylang.evalex.data.conversion.ConverterIfc;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ArrayConverter
implements ConverterIfc {
    @Override
    public EvaluationValue convert(Object object, ExpressionConfiguration configuration) {
        List<EvaluationValue> list;
        if (object.getClass().isArray()) {
            list = this.convertArray(object, configuration);
        } else if (object instanceof List) {
            list = ArrayConverter.convertList((List)object, configuration);
        } else {
            throw this.illegalArgument(object);
        }
        return EvaluationValue.arrayValue(list);
    }

    @Override
    public boolean canConvert(Object object) {
        return object instanceof List || object.getClass().isArray();
    }

    private static List<EvaluationValue> convertList(List<?> object, ExpressionConfiguration configuration) {
        return object.stream().map(element -> EvaluationValue.of(element, configuration)).collect(Collectors.toList());
    }

    private List<EvaluationValue> convertArray(Object array, ExpressionConfiguration configuration) {
        if (array instanceof int[]) {
            return this.convertIntArray((int[])array, configuration);
        }
        if (array instanceof long[]) {
            return this.convertLongArray((long[])array, configuration);
        }
        if (array instanceof double[]) {
            return this.convertDoubleArray((double[])array, configuration);
        }
        if (array instanceof float[]) {
            return this.convertFloatArray((float[])array, configuration);
        }
        if (array instanceof short[]) {
            return this.convertShortArray((short[])array, configuration);
        }
        if (array instanceof char[]) {
            return this.convertCharArray((char[])array, configuration);
        }
        if (array instanceof byte[]) {
            return this.convertByteArray((byte[])array, configuration);
        }
        if (array instanceof boolean[]) {
            return this.convertBooleanArray((boolean[])array, configuration);
        }
        return this.convertObjectArray((Object[])array, configuration);
    }

    private List<EvaluationValue> convertIntArray(int[] array, ExpressionConfiguration configuration) {
        ArrayList<EvaluationValue> list = new ArrayList<EvaluationValue>();
        for (int i2 : array) {
            list.add(EvaluationValue.of(i2, configuration));
        }
        return list;
    }

    private List<EvaluationValue> convertLongArray(long[] array, ExpressionConfiguration configuration) {
        ArrayList<EvaluationValue> list = new ArrayList<EvaluationValue>();
        for (long l : array) {
            list.add(EvaluationValue.of(l, configuration));
        }
        return list;
    }

    private List<EvaluationValue> convertDoubleArray(double[] array, ExpressionConfiguration configuration) {
        ArrayList<EvaluationValue> list = new ArrayList<EvaluationValue>();
        for (double d2 : array) {
            list.add(EvaluationValue.of(d2, configuration));
        }
        return list;
    }

    private List<EvaluationValue> convertFloatArray(float[] array, ExpressionConfiguration configuration) {
        ArrayList<EvaluationValue> list = new ArrayList<EvaluationValue>();
        for (float f2 : array) {
            list.add(EvaluationValue.of(Float.valueOf(f2), configuration));
        }
        return list;
    }

    private List<EvaluationValue> convertShortArray(short[] array, ExpressionConfiguration configuration) {
        ArrayList<EvaluationValue> list = new ArrayList<EvaluationValue>();
        for (short s2 : array) {
            list.add(EvaluationValue.of(s2, configuration));
        }
        return list;
    }

    private List<EvaluationValue> convertCharArray(char[] array, ExpressionConfiguration configuration) {
        ArrayList<EvaluationValue> list = new ArrayList<EvaluationValue>();
        for (char c2 : array) {
            list.add(EvaluationValue.of(Character.valueOf(c2), configuration));
        }
        return list;
    }

    private List<EvaluationValue> convertByteArray(byte[] array, ExpressionConfiguration configuration) {
        ArrayList<EvaluationValue> list = new ArrayList<EvaluationValue>();
        for (byte b2 : array) {
            list.add(EvaluationValue.of(b2, configuration));
        }
        return list;
    }

    private List<EvaluationValue> convertBooleanArray(boolean[] array, ExpressionConfiguration configuration) {
        ArrayList<EvaluationValue> list = new ArrayList<EvaluationValue>();
        for (boolean b2 : array) {
            list.add(EvaluationValue.of(b2, configuration));
        }
        return list;
    }

    private List<EvaluationValue> convertObjectArray(Object[] array, ExpressionConfiguration configuration) {
        ArrayList<EvaluationValue> list = new ArrayList<EvaluationValue>();
        for (Object o : array) {
            list.add(EvaluationValue.of(o, configuration));
        }
        return list;
    }
}

