/*
 * Decompiled with CFR 0.152.
 */
package com.ezylang.evalex.functions;

import com.ezylang.evalex.EvaluationException;
import com.ezylang.evalex.data.EvaluationValue;
import com.ezylang.evalex.functions.FunctionIfc;
import com.ezylang.evalex.functions.FunctionParameter;
import com.ezylang.evalex.functions.FunctionParameterDefinition;
import com.ezylang.evalex.parser.Token;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractFunction
implements FunctionIfc {
    protected static final BigDecimal MINUS_ONE = BigDecimal.valueOf(-1L);
    private final List<FunctionParameterDefinition> functionParameterDefinitions = new ArrayList<FunctionParameterDefinition>();
    private final boolean hasVarArgs;

    protected AbstractFunction() {
        FunctionParameter[] parameterAnnotations = (FunctionParameter[])this.getClass().getAnnotationsByType(FunctionParameter.class);
        boolean varArgParameterFound = false;
        for (FunctionParameter parameter : parameterAnnotations) {
            if (varArgParameterFound) {
                throw new IllegalArgumentException("Only last parameter may be defined as variable argument");
            }
            if (parameter.isVarArg()) {
                varArgParameterFound = true;
            }
            this.functionParameterDefinitions.add(FunctionParameterDefinition.builder().name(parameter.name()).isVarArg(parameter.isVarArg()).isLazy(parameter.isLazy()).nonZero(parameter.nonZero()).nonNegative(parameter.nonNegative()).build());
        }
        this.hasVarArgs = varArgParameterFound;
    }

    @Override
    public void validatePreEvaluation(Token token2, EvaluationValue ... parameterValues) throws EvaluationException {
        for (int i2 = 0; i2 < parameterValues.length; ++i2) {
            FunctionParameterDefinition definition = this.getParameterDefinitionForParameter(i2);
            if (definition.isNonZero() && parameterValues[i2].getNumberValue().equals(BigDecimal.ZERO)) {
                throw new EvaluationException(token2, "Parameter must not be zero");
            }
            if (!definition.isNonNegative() || parameterValues[i2].getNumberValue().signum() >= 0) continue;
            throw new EvaluationException(token2, "Parameter must not be negative");
        }
    }

    @Override
    public List<FunctionParameterDefinition> getFunctionParameterDefinitions() {
        return this.functionParameterDefinitions;
    }

    @Override
    public boolean hasVarArgs() {
        return this.hasVarArgs;
    }

    private FunctionParameterDefinition getParameterDefinitionForParameter(int index) {
        if (this.hasVarArgs && index >= this.functionParameterDefinitions.size()) {
            index = this.functionParameterDefinitions.size() - 1;
        }
        return this.functionParameterDefinitions.get(index);
    }
}

