/*
 * Decompiled with CFR 0.152.
 */
package com.ezylang.evalex.functions.datetime;

import com.ezylang.evalex.EvaluationException;
import com.ezylang.evalex.Expression;
import com.ezylang.evalex.data.EvaluationValue;
import com.ezylang.evalex.data.conversion.DateTimeConverter;
import com.ezylang.evalex.functions.AbstractFunction;
import com.ezylang.evalex.functions.FunctionParameter;
import com.ezylang.evalex.functions.FunctionParameters;
import com.ezylang.evalex.functions.datetime.ZoneIdConverter;
import com.ezylang.evalex.parser.Token;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;

@FunctionParameters(value={@FunctionParameter(name="value"), @FunctionParameter(name="parameters", isVarArg=true)})
public class DateTimeParseFunction
extends AbstractFunction {
    @Override
    public EvaluationValue evaluate(Expression expression, Token functionToken, EvaluationValue ... parameterValues) throws EvaluationException {
        DateTimeConverter converter;
        Instant instant;
        ArrayList<DateTimeFormatter> formatters;
        String value2 = parameterValues[0].getStringValue();
        ZoneId zoneId = expression.getConfiguration().getZoneId();
        if (parameterValues.length > 1 && !parameterValues[1].isNullValue()) {
            zoneId = ZoneIdConverter.convert(functionToken, parameterValues[1].getStringValue());
        }
        if (parameterValues.length > 2) {
            formatters = new ArrayList();
            for (int i2 = 2; i2 < parameterValues.length; ++i2) {
                try {
                    formatters.add(DateTimeFormatter.ofPattern(parameterValues[i2].getStringValue()));
                    continue;
                }
                catch (IllegalArgumentException ex) {
                    throw new EvaluationException(functionToken, String.format("Illegal date-time format in parameter %d: '%s'", i2 + 1, parameterValues[i2].getStringValue()));
                }
            }
        } else {
            formatters = expression.getConfiguration().getDateTimeFormatters();
        }
        if ((instant = (converter = new DateTimeConverter()).parseDateTime(value2, zoneId, formatters)) == null) {
            throw new EvaluationException(functionToken, String.format("Unable to parse date-time string '%s'", value2));
        }
        return EvaluationValue.dateTimeValue(instant);
    }
}

