/*
 * Decompiled with CFR 0.152.
 */
package com.ezylang.evalex.functions.datetime;

import com.ezylang.evalex.Expression;
import com.ezylang.evalex.data.EvaluationValue;
import com.ezylang.evalex.functions.AbstractFunction;
import com.ezylang.evalex.functions.FunctionParameter;
import com.ezylang.evalex.functions.FunctionParameters;
import com.ezylang.evalex.parser.Token;
import java.time.Duration;

@FunctionParameters(value={@FunctionParameter(name="days"), @FunctionParameter(name="parameters", isVarArg=true)})
public class DurationNewFunction
extends AbstractFunction {
    @Override
    public EvaluationValue evaluate(Expression expression, Token functionToken, EvaluationValue ... parameterValues) {
        int parameterLength = parameterValues.length;
        int days = parameterValues[0].getNumberValue().intValue();
        int hours = parameterLength >= 2 ? parameterValues[1].getNumberValue().intValue() : 0;
        int minutes = parameterLength >= 3 ? parameterValues[2].getNumberValue().intValue() : 0;
        int seconds = parameterLength >= 4 ? parameterValues[3].getNumberValue().intValue() : 0;
        int millis = parameterLength >= 5 ? parameterValues[4].getNumberValue().intValue() : 0;
        int nanos = parameterLength == 6 ? parameterValues[5].getNumberValue().intValue() : 0;
        Duration duration = Duration.ofDays(days).plusHours(hours).plusMinutes(minutes).plusSeconds(seconds).plusMillis(millis).plusNanos(nanos);
        return expression.convertValue(duration);
    }
}

