/*
 * Decompiled with CFR 0.152.
 */
package com.ezylang.evalex.functions.trigonometric;

import com.ezylang.evalex.EvaluationException;
import com.ezylang.evalex.Expression;
import com.ezylang.evalex.data.EvaluationValue;
import com.ezylang.evalex.functions.AbstractFunction;
import com.ezylang.evalex.functions.FunctionParameter;
import com.ezylang.evalex.parser.Token;

@FunctionParameter(name="value")
public class AcosHFunction
extends AbstractFunction {
    @Override
    public EvaluationValue evaluate(Expression expression, Token functionToken, EvaluationValue ... parameterValues) throws EvaluationException {
        double value2 = parameterValues[0].getNumberValue().doubleValue();
        if (Double.compare(value2, 1.0) < 0) {
            throw new EvaluationException(functionToken, "Value must be greater or equal to one");
        }
        return expression.convertDoubleValue(Math.log(value2 + Math.sqrt(Math.pow(value2, 2.0) - 1.0)));
    }
}

