/*
 * Decompiled with CFR 0.152.
 */
package com.ezylang.evalex.functions.trigonometric;

import com.ezylang.evalex.EvaluationException;
import com.ezylang.evalex.Expression;
import com.ezylang.evalex.data.EvaluationValue;
import com.ezylang.evalex.functions.AbstractFunction;
import com.ezylang.evalex.functions.FunctionParameter;
import com.ezylang.evalex.parser.Token;

@FunctionParameter(name="value")
public class AtanHFunction
extends AbstractFunction {
    @Override
    public EvaluationValue evaluate(Expression expression, Token functionToken, EvaluationValue ... parameterValues) throws EvaluationException {
        double value2 = parameterValues[0].getNumberValue().doubleValue();
        if (Math.abs(value2) >= 1.0) {
            throw new EvaluationException(functionToken, "Absolute value must be less than 1");
        }
        return expression.convertDoubleValue(0.5 * Math.log((1.0 + value2) / (1.0 - value2)));
    }
}

