/*
 * Decompiled with CFR 0.152.
 */
package com.ezylang.evalex.parser;

import com.ezylang.evalex.config.ExpressionConfiguration;
import com.ezylang.evalex.functions.FunctionIfc;
import com.ezylang.evalex.operators.OperatorIfc;
import com.ezylang.evalex.parser.ASTNode;
import com.ezylang.evalex.parser.ParseException;
import com.ezylang.evalex.parser.Token;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;

public class ShuntingYardConverter {
    private final List<Token> expressionTokens;
    private final String originalExpression;
    private final ExpressionConfiguration configuration;
    private final Deque<Token> operatorStack = new ArrayDeque<Token>();
    private final Deque<ASTNode> operandStack = new ArrayDeque<ASTNode>();

    public ShuntingYardConverter(String originalExpression, List<Token> expressionTokens, ExpressionConfiguration configuration) {
        this.originalExpression = originalExpression;
        this.expressionTokens = expressionTokens;
        this.configuration = configuration;
    }

    public ASTNode toAbstractSyntaxTree() throws ParseException {
        Token previousToken = null;
        for (Token currentToken : this.expressionTokens) {
            switch (currentToken.getType()) {
                case VARIABLE_OR_CONSTANT: 
                case NUMBER_LITERAL: 
                case STRING_LITERAL: {
                    this.operandStack.push(new ASTNode(currentToken, new ASTNode[0]));
                    break;
                }
                case FUNCTION: {
                    this.operatorStack.push(currentToken);
                    break;
                }
                case COMMA: {
                    this.processOperatorsFromStackUntilTokenType(Token.TokenType.BRACE_OPEN);
                    break;
                }
                case INFIX_OPERATOR: 
                case PREFIX_OPERATOR: 
                case POSTFIX_OPERATOR: {
                    this.processOperator(currentToken);
                    break;
                }
                case BRACE_OPEN: {
                    this.processBraceOpen(previousToken, currentToken);
                    break;
                }
                case BRACE_CLOSE: {
                    this.processBraceClose();
                    break;
                }
                case ARRAY_OPEN: {
                    this.processArrayOpen(currentToken);
                    break;
                }
                case ARRAY_CLOSE: {
                    this.processArrayClose();
                    break;
                }
                case STRUCTURE_SEPARATOR: {
                    this.processStructureSeparator(currentToken);
                    break;
                }
                default: {
                    throw new ParseException(currentToken, "Unexpected token of type '" + String.valueOf((Object)currentToken.getType()) + "'");
                }
            }
            previousToken = currentToken;
        }
        while (!this.operatorStack.isEmpty()) {
            Token token2 = this.operatorStack.pop();
            this.createOperatorNode(token2);
        }
        if (this.operandStack.isEmpty()) {
            throw new ParseException(this.originalExpression, "Empty expression");
        }
        if (this.operandStack.size() > 1) {
            throw new ParseException(this.originalExpression, "Too many operands");
        }
        return this.operandStack.pop();
    }

    private void processStructureSeparator(Token currentToken) throws ParseException {
        Token nextToken;
        Token token2 = nextToken = this.operatorStack.isEmpty() ? null : this.operatorStack.peek();
        while (nextToken != null && nextToken.getType() == Token.TokenType.STRUCTURE_SEPARATOR) {
            Token token3 = this.operatorStack.pop();
            this.createOperatorNode(token3);
            nextToken = this.operatorStack.peek();
        }
        this.operatorStack.push(currentToken);
    }

    private void processBraceOpen(Token previousToken, Token currentToken) {
        if (previousToken != null && previousToken.getType() == Token.TokenType.FUNCTION) {
            Token paramStart = new Token(currentToken.getStartPosition(), currentToken.getValue(), Token.TokenType.FUNCTION_PARAM_START);
            this.operandStack.push(new ASTNode(paramStart, new ASTNode[0]));
        }
        this.operatorStack.push(currentToken);
    }

    private void processBraceClose() throws ParseException {
        this.processOperatorsFromStackUntilTokenType(Token.TokenType.BRACE_OPEN);
        this.operatorStack.pop();
        if (!this.operatorStack.isEmpty() && this.operatorStack.peek().getType() == Token.TokenType.FUNCTION) {
            ASTNode node;
            Token functionToken = this.operatorStack.pop();
            ArrayList<ASTNode> parameters2 = new ArrayList<ASTNode>();
            while ((node = this.operandStack.pop()).getToken().getType() != Token.TokenType.FUNCTION_PARAM_START) {
                parameters2.add(0, node);
            }
            this.validateFunctionParameters(functionToken, parameters2);
            this.operandStack.push(new ASTNode(functionToken, parameters2.toArray(new ASTNode[0])));
        }
    }

    private void validateFunctionParameters(Token functionToken, ArrayList<ASTNode> parameters2) throws ParseException {
        FunctionIfc function = functionToken.getFunctionDefinition();
        if (parameters2.size() < function.getCountOfNonVarArgParameters()) {
            throw new ParseException(functionToken, "Not enough parameters for function");
        }
        if (!function.hasVarArgs() && parameters2.size() > function.getFunctionParameterDefinitions().size()) {
            throw new ParseException(functionToken, "Too many parameters for function");
        }
    }

    private void processArrayOpen(Token currentToken) throws ParseException {
        Token nextToken;
        Token token2 = nextToken = this.operatorStack.isEmpty() ? null : this.operatorStack.peek();
        while (nextToken != null && nextToken.getType() == Token.TokenType.STRUCTURE_SEPARATOR) {
            Token token3 = this.operatorStack.pop();
            this.createOperatorNode(token3);
            nextToken = this.operatorStack.isEmpty() ? null : this.operatorStack.peek();
        }
        Token arrayIndex = new Token(currentToken.getStartPosition(), currentToken.getValue(), Token.TokenType.ARRAY_INDEX);
        this.operatorStack.push(arrayIndex);
        this.operatorStack.push(currentToken);
    }

    private void processArrayClose() throws ParseException {
        this.processOperatorsFromStackUntilTokenType(Token.TokenType.ARRAY_OPEN);
        this.operatorStack.pop();
        Token arrayToken = this.operatorStack.pop();
        ArrayList<ASTNode> operands = new ArrayList<ASTNode>();
        ASTNode index = this.operandStack.pop();
        operands.add(0, index);
        ASTNode array = this.operandStack.pop();
        operands.add(0, array);
        this.operandStack.push(new ASTNode(arrayToken, operands.toArray(new ASTNode[0])));
    }

    private void processOperatorsFromStackUntilTokenType(Token.TokenType untilTokenType) throws ParseException {
        while (!this.operatorStack.isEmpty() && this.operatorStack.peek().getType() != untilTokenType) {
            Token token2 = this.operatorStack.pop();
            this.createOperatorNode(token2);
        }
    }

    private void createOperatorNode(Token token2) throws ParseException {
        if (this.operandStack.isEmpty()) {
            throw new ParseException(token2, "Missing operand for operator");
        }
        ASTNode operand1 = this.operandStack.pop();
        if (token2.getType() == Token.TokenType.PREFIX_OPERATOR || token2.getType() == Token.TokenType.POSTFIX_OPERATOR) {
            this.operandStack.push(new ASTNode(token2, operand1));
        } else {
            if (this.operandStack.isEmpty()) {
                throw new ParseException(token2, "Missing second operand for operator");
            }
            ASTNode operand2 = this.operandStack.pop();
            this.operandStack.push(new ASTNode(token2, operand2, operand1));
        }
    }

    private void processOperator(Token currentToken) throws ParseException {
        Token nextToken;
        Token token2 = nextToken = this.operatorStack.isEmpty() ? null : this.operatorStack.peek();
        while (this.isOperator(nextToken) && this.isNextOperatorOfHigherPrecedence(currentToken.getOperatorDefinition(), nextToken.getOperatorDefinition())) {
            Token token3 = this.operatorStack.pop();
            this.createOperatorNode(token3);
            nextToken = this.operatorStack.isEmpty() ? null : this.operatorStack.peek();
        }
        this.operatorStack.push(currentToken);
    }

    private boolean isNextOperatorOfHigherPrecedence(OperatorIfc currentOperator, OperatorIfc nextOperator) {
        if (nextOperator == null) {
            return true;
        }
        if (currentOperator.isLeftAssociative()) {
            return currentOperator.getPrecedence(this.configuration) <= nextOperator.getPrecedence(this.configuration);
        }
        return currentOperator.getPrecedence(this.configuration) < nextOperator.getPrecedence(this.configuration);
    }

    private boolean isOperator(Token token2) {
        if (token2 == null) {
            return false;
        }
        Token.TokenType tokenType = token2.getType();
        switch (tokenType) {
            case INFIX_OPERATOR: 
            case PREFIX_OPERATOR: 
            case POSTFIX_OPERATOR: 
            case STRUCTURE_SEPARATOR: {
                return true;
            }
        }
        return false;
    }
}

