/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.internal.shaded.fdp.v2_20_0;

import com.fasterxml.jackson.core.internal.shaded.fdp.v2_20_0.BigSignificand;
import com.fasterxml.jackson.core.internal.shaded.fdp.v2_20_0.FastDoubleSwar;
import com.fasterxml.jackson.core.internal.shaded.fdp.v2_20_0.FastIntegerMath;
import com.fasterxml.jackson.core.internal.shaded.fdp.v2_20_0.FftMultiplier;
import java.math.BigInteger;
import java.util.Map;

final class ParseDigitsTaskByteArray {
    private ParseDigitsTaskByteArray() {
    }

    static BigInteger parseDigitsIterative(byte[] str, int from2, int to) {
        assert (str != null) : "str==null";
        int numDigits = to - from2;
        BigSignificand bigSignificand = new BigSignificand(FastIntegerMath.estimateNumBits(numDigits));
        int preroll = from2 + (numDigits & 7);
        int value2 = FastDoubleSwar.tryToParseUpTo7Digits(str, from2, preroll);
        boolean success = value2 >= 0;
        bigSignificand.add(value2);
        for (from2 = preroll; from2 < to; from2 += 8) {
            int addend = FastDoubleSwar.tryToParseEightDigits(str, from2);
            success &= addend >= 0;
            bigSignificand.fma(100000000, addend);
        }
        if (!success) {
            throw new NumberFormatException("illegal syntax");
        }
        return bigSignificand.toBigInteger();
    }

    static BigInteger parseDigitsRecursive(byte[] str, int from2, int to, Map<Integer, BigInteger> powersOfTen, int recursionThreshold) {
        assert (str != null) : "str==null";
        assert (powersOfTen != null) : "powersOfTen==null";
        int numDigits = to - from2;
        if (numDigits <= recursionThreshold) {
            return ParseDigitsTaskByteArray.parseDigitsIterative(str, from2, to);
        }
        int mid = FastIntegerMath.splitFloor16(from2, to);
        BigInteger high = ParseDigitsTaskByteArray.parseDigitsRecursive(str, from2, mid, powersOfTen, recursionThreshold);
        BigInteger low = ParseDigitsTaskByteArray.parseDigitsRecursive(str, mid, to, powersOfTen, recursionThreshold);
        high = FftMultiplier.multiply(high, powersOfTen.get(to - mid));
        return low.add(high);
    }
}

