/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.SettableAnyProperty;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;

public abstract class PropertyValue {
    public final PropertyValue next;
    public final Object value;

    protected PropertyValue(PropertyValue next2, Object value2) {
        this.next = next2;
        this.value = value2;
    }

    @Deprecated
    public final void assign(Object bean) throws IOException {
        this.assign(null, bean);
    }

    public void assign(DeserializationContext ctxt, Object bean) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void setValue(Object parameterObject) throws IOException {
        throw new UnsupportedOperationException("Should not be called on type: " + this.getClass().getName());
    }

    static final class Merging
    extends PropertyValue {
        final SettableBeanProperty _property;

        public Merging(PropertyValue next2, TokenBuffer buffered, SettableBeanProperty prop) {
            super(next2, buffered);
            this._property = prop;
        }

        @Override
        public void assign(DeserializationContext ctxt, Object bean) throws IOException {
            TokenBuffer buffered = (TokenBuffer)this.value;
            try (JsonParser p = buffered.asParser();){
                p.nextToken();
                this._property.deserializeAndSet(p, ctxt, bean);
            }
        }
    }

    static final class AnyParameter
    extends PropertyValue {
        final SettableAnyProperty _property;
        final String _propertyName;

        public AnyParameter(PropertyValue next2, Object value2, SettableAnyProperty prop, String propName) {
            super(next2, value2);
            this._property = prop;
            this._propertyName = propName;
        }

        @Override
        public void assign(DeserializationContext ctxt, Object bean) throws IOException {
        }

        @Override
        public void setValue(Object parameterObject) throws IOException {
            this._property.set(parameterObject, this._propertyName, this.value);
        }
    }

    static final class Map
    extends PropertyValue {
        final Object _key;

        public Map(PropertyValue next2, Object value2, Object key2) {
            super(next2, value2);
            this._key = key2;
        }

        @Override
        public void assign(DeserializationContext ctxt, Object bean) throws IOException {
            ((java.util.Map)bean).put(this._key, this.value);
        }
    }

    static final class Any
    extends PropertyValue {
        final SettableAnyProperty _property;
        final String _propertyName;

        public Any(PropertyValue next2, Object value2, SettableAnyProperty prop, String propName) {
            super(next2, value2);
            this._property = prop;
            this._propertyName = propName;
        }

        @Override
        public void assign(DeserializationContext ctxt, Object bean) throws IOException {
            this._property.set(bean, this._propertyName, this.value);
        }
    }

    static final class Regular
    extends PropertyValue {
        final SettableBeanProperty _property;

        public Regular(PropertyValue next2, Object value2, SettableBeanProperty prop) {
            super(next2, value2);
            this._property = prop;
        }

        @Override
        public void assign(DeserializationContext ctxt, Object bean) throws IOException {
            this._property.set(bean, this.value);
        }
    }
}

