/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ext;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.databind.ser.std.CalendarSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import java.io.IOException;
import java.util.Calendar;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;

public class CoreXMLSerializers
extends Serializers.Base {
    @Override
    public JsonSerializer<?> findSerializer(SerializationConfig config2, JavaType type2, BeanDescription beanDesc) {
        Class<?> raw = type2.getRawClass();
        if (Duration.class.isAssignableFrom(raw)) {
            return ToStringSerializer.instance;
        }
        if (QName.class.isAssignableFrom(raw)) {
            return QNameSerializer.instance;
        }
        if (XMLGregorianCalendar.class.isAssignableFrom(raw)) {
            return XMLGregorianCalendarSerializer.instance;
        }
        return null;
    }

    public static class QNameSerializer
    extends StdSerializer<QName>
    implements ContextualSerializer {
        private static final long serialVersionUID = 1L;
        public static final JsonSerializer<?> instance = new QNameSerializer();

        public QNameSerializer() {
            super(QName.class);
        }

        @Override
        public JsonSerializer<?> createContextual(SerializerProvider serializers, BeanProperty property2) throws JsonMappingException {
            JsonFormat.Shape shape;
            JsonFormat.Value format2 = this.findFormatOverrides(serializers, property2, this.handledType());
            if (format2 != null && (shape = format2.getShape()) == JsonFormat.Shape.OBJECT) {
                return this;
            }
            return ToStringSerializer.instance;
        }

        @Override
        public void serialize(QName value2, JsonGenerator g2, SerializerProvider ctxt) throws IOException {
            g2.writeStartObject(value2);
            this.serializeProperties(value2, g2, ctxt);
            g2.writeEndObject();
        }

        @Override
        public final void serializeWithType(QName value2, JsonGenerator g2, SerializerProvider ctxt, TypeSerializer typeSer) throws IOException {
            WritableTypeId typeIdDef = typeSer.writeTypePrefix(g2, typeSer.typeId(value2, JsonToken.START_OBJECT));
            this.serializeProperties(value2, g2, ctxt);
            typeSer.writeTypeSuffix(g2, typeIdDef);
        }

        private void serializeProperties(QName value2, JsonGenerator g2, SerializerProvider ctxt) throws IOException {
            g2.writeStringField("localPart", value2.getLocalPart());
            if (!value2.getNamespaceURI().isEmpty()) {
                g2.writeStringField("namespaceURI", value2.getNamespaceURI());
            }
            if (!value2.getPrefix().isEmpty()) {
                g2.writeStringField("prefix", value2.getPrefix());
            }
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor2, JavaType typeHint) throws JsonMappingException {
            visitor2.expectObjectFormat(typeHint);
        }
    }

    public static class XMLGregorianCalendarSerializer
    extends StdSerializer<XMLGregorianCalendar>
    implements ContextualSerializer {
        static final XMLGregorianCalendarSerializer instance = new XMLGregorianCalendarSerializer();
        final JsonSerializer<Object> _delegate;

        public XMLGregorianCalendarSerializer() {
            this(CalendarSerializer.instance);
        }

        protected XMLGregorianCalendarSerializer(JsonSerializer<?> del) {
            super(XMLGregorianCalendar.class);
            this._delegate = del;
        }

        @Override
        public JsonSerializer<?> getDelegatee() {
            return this._delegate;
        }

        @Override
        public boolean isEmpty(SerializerProvider provider2, XMLGregorianCalendar value2) {
            return this._delegate.isEmpty(provider2, this._convert(value2));
        }

        @Override
        public void serialize(XMLGregorianCalendar value2, JsonGenerator gen, SerializerProvider provider2) throws IOException {
            this._delegate.serialize(this._convert(value2), gen, provider2);
        }

        @Override
        public void serializeWithType(XMLGregorianCalendar value2, JsonGenerator g2, SerializerProvider provider2, TypeSerializer typeSer) throws IOException {
            WritableTypeId typeIdDef = typeSer.writeTypePrefix(g2, typeSer.typeId((Object)value2, XMLGregorianCalendar.class, JsonToken.VALUE_STRING));
            this.serialize(value2, g2, provider2);
            typeSer.writeTypeSuffix(g2, typeIdDef);
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor2, JavaType typeHint) throws JsonMappingException {
            this._delegate.acceptJsonFormatVisitor(visitor2, null);
        }

        @Override
        public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property2) throws JsonMappingException {
            JsonSerializer<?> ser = prov.handlePrimaryContextualization(this._delegate, property2);
            if (ser != this._delegate) {
                return new XMLGregorianCalendarSerializer(ser);
            }
            return this;
        }

        protected Calendar _convert(XMLGregorianCalendar input) {
            return input == null ? null : input.toGregorianCalendar();
        }
    }
}

