/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.introspect;

import com.fasterxml.jackson.annotation.JacksonAnnotationsInside;
import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIdentityReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonIncludeProperties;
import com.fasterxml.jackson.annotation.JsonKey;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.fasterxml.jackson.annotation.JsonMerge;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRawValue;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.annotation.OptBoolean;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.PropertyMetadata;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.annotation.EnumNaming;
import com.fasterxml.jackson.databind.annotation.JsonAppend;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import com.fasterxml.jackson.databind.annotation.JsonTypeResolver;
import com.fasterxml.jackson.databind.annotation.JsonValueInstantiator;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.cfg.PackageVersion;
import com.fasterxml.jackson.databind.ext.Java7Support;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.fasterxml.jackson.databind.introspect.VirtualAnnotatedMember;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.jsontype.impl.StdTypeResolverBuilder;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.VirtualBeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.AttributePropertyWriter;
import com.fasterxml.jackson.databind.ser.std.RawSerializer;
import com.fasterxml.jackson.databind.type.MapLikeType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.Converter;
import com.fasterxml.jackson.databind.util.ExceptionUtil;
import com.fasterxml.jackson.databind.util.LRUMap;
import com.fasterxml.jackson.databind.util.NameTransformer;
import com.fasterxml.jackson.databind.util.SimpleBeanPropertyDefinition;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;

public class JacksonAnnotationIntrospector
extends AnnotationIntrospector
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Class<? extends Annotation>[] ANNOTATIONS_TO_INFER_SER = new Class[]{JsonSerialize.class, JsonView.class, JsonFormat.class, JsonTypeInfo.class, JsonRawValue.class, JsonUnwrapped.class, JsonBackReference.class, JsonManagedReference.class};
    private static final Class<? extends Annotation>[] ANNOTATIONS_TO_INFER_DESER = new Class[]{JsonDeserialize.class, JsonView.class, JsonFormat.class, JsonTypeInfo.class, JsonUnwrapped.class, JsonBackReference.class, JsonManagedReference.class, JsonMerge.class};
    private static final Java7Support _java7Helper;
    protected transient LRUMap<String, Boolean> _annotationsInside = new LRUMap(48, 48);
    protected boolean _cfgConstructorPropertiesImpliesCreator = true;

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    protected Object readResolve() {
        if (this._annotationsInside == null) {
            this._annotationsInside = new LRUMap(48, 48);
        }
        return this;
    }

    public JacksonAnnotationIntrospector setConstructorPropertiesImpliesCreator(boolean b2) {
        this._cfgConstructorPropertiesImpliesCreator = b2;
        return this;
    }

    @Override
    public boolean isAnnotationBundle(Annotation ann) {
        Class<? extends Annotation> type2 = ann.annotationType();
        String typeName2 = type2.getName();
        Boolean b2 = this._annotationsInside.get(typeName2);
        if (b2 == null) {
            b2 = type2.getAnnotation(JacksonAnnotationsInside.class) != null;
            this._annotationsInside.putIfAbsent(typeName2, b2);
        }
        return b2;
    }

    @Override
    @Deprecated
    public String[] findEnumValues(Class<?> enumType, Enum<?>[] enumValues, String[] names2) {
        HashMap<String, String> expl = null;
        for (Field f2 : enumType.getDeclaredFields()) {
            JsonProperty prop;
            if (!f2.isEnumConstant() || (prop = f2.getAnnotation(JsonProperty.class)) == null) continue;
            String n = prop.value();
            if (expl == null) {
                expl = new HashMap<String, String>();
            }
            expl.put(f2.getName(), n);
        }
        if (expl != null) {
            int end2 = enumValues.length;
            for (int i2 = 0; i2 < end2; ++i2) {
                String defName = enumValues[i2].name();
                String explValue = (String)expl.get(defName);
                if (explValue == null) continue;
                names2[i2] = explValue;
            }
        }
        return names2;
    }

    @Override
    public String[] findEnumValues(MapperConfig<?> config2, AnnotatedClass annotatedClass, Enum<?>[] enumValues, String[] names2) {
        LinkedHashMap<String, String> enumToPropertyMap = new LinkedHashMap<String, String>();
        for (AnnotatedField field : annotatedClass.fields()) {
            String propValue;
            JsonProperty property2 = field.getAnnotation(JsonProperty.class);
            if (property2 == null || (propValue = property2.value()) == null) continue;
            enumToPropertyMap.put(field.getName(), propValue);
        }
        int end2 = enumValues.length;
        for (int i2 = 0; i2 < end2; ++i2) {
            String defName = enumValues[i2].name();
            String explValue = (String)enumToPropertyMap.get(defName);
            if (explValue == null) continue;
            names2[i2] = explValue;
        }
        return names2;
    }

    @Override
    @Deprecated
    public void findEnumAliases(Class<?> enumType, Enum<?>[] enumValues, String[][] aliasList) {
        for (Field f2 : enumType.getDeclaredFields()) {
            String[] aliases;
            JsonAlias aliasAnnotation;
            if (!f2.isEnumConstant() || (aliasAnnotation = f2.getAnnotation(JsonAlias.class)) == null || (aliases = aliasAnnotation.value()).length == 0) continue;
            String name = f2.getName();
            int end2 = enumValues.length;
            for (int i2 = 0; i2 < end2; ++i2) {
                if (!name.equals(enumValues[i2].name())) continue;
                aliasList[i2] = aliases;
            }
        }
    }

    @Override
    public void findEnumAliases(MapperConfig<?> config2, AnnotatedClass annotatedClass, Enum<?>[] enumValues, String[][] aliasList) {
        HashMap<String, String[]> enumToAliasMap = new HashMap<String, String[]>();
        for (AnnotatedField field : annotatedClass.fields()) {
            JsonAlias alias = field.getAnnotation(JsonAlias.class);
            if (alias == null) continue;
            enumToAliasMap.putIfAbsent(field.getName(), alias.value());
        }
        for (Enum<?> enumValue : enumValues) {
            aliasList[i] = enumToAliasMap.getOrDefault(enumValue.name(), new String[0]);
        }
    }

    @Override
    @Deprecated
    public Enum<?> findDefaultEnumValue(Class<Enum<?>> enumCls) {
        return ClassUtil.findFirstAnnotatedEnumValue(enumCls, JsonEnumDefaultValue.class);
    }

    @Override
    public Enum<?> findDefaultEnumValue(AnnotatedClass annotatedClass, Enum<?>[] enumValues) {
        for (Annotated annotated : annotatedClass.fields()) {
            JsonEnumDefaultValue found;
            if (!annotated.getType().isEnumType() || (found = this._findAnnotation(annotated, JsonEnumDefaultValue.class)) == null) continue;
            for (Enum<?> enumValue : enumValues) {
                if (!enumValue.name().equals(annotated.getName())) continue;
                return enumValue;
            }
        }
        return null;
    }

    @Override
    public PropertyName findRootName(AnnotatedClass ac) {
        JsonRootName ann = this._findAnnotation(ac, JsonRootName.class);
        if (ann == null) {
            return null;
        }
        String ns = ann.namespace();
        if (ns != null && ns.isEmpty()) {
            ns = null;
        }
        return PropertyName.construct(ann.value(), ns);
    }

    @Override
    public Boolean isIgnorableType(AnnotatedClass ac) {
        JsonIgnoreType ignore = this._findAnnotation(ac, JsonIgnoreType.class);
        return ignore == null ? null : Boolean.valueOf(ignore.value());
    }

    @Override
    public JsonIgnoreProperties.Value findPropertyIgnoralByName(MapperConfig<?> config2, Annotated a2) {
        JsonIgnoreProperties v = this._findAnnotation(a2, JsonIgnoreProperties.class);
        if (v == null) {
            return JsonIgnoreProperties.Value.empty();
        }
        return JsonIgnoreProperties.Value.from(v);
    }

    @Override
    @Deprecated
    public JsonIgnoreProperties.Value findPropertyIgnorals(Annotated ac) {
        return this.findPropertyIgnoralByName(null, ac);
    }

    @Override
    public JsonIncludeProperties.Value findPropertyInclusionByName(MapperConfig<?> config2, Annotated a2) {
        JsonIncludeProperties v = this._findAnnotation(a2, JsonIncludeProperties.class);
        if (v == null) {
            return JsonIncludeProperties.Value.all();
        }
        return JsonIncludeProperties.Value.from(v);
    }

    @Override
    public Object findFilterId(Annotated a2) {
        String id;
        JsonFilter ann = this._findAnnotation(a2, JsonFilter.class);
        if (ann != null && !(id = ann.value()).isEmpty()) {
            return id;
        }
        return null;
    }

    @Override
    public Object findNamingStrategy(AnnotatedClass ac) {
        JsonNaming ann = this._findAnnotation(ac, JsonNaming.class);
        return ann == null ? null : ann.value();
    }

    @Override
    public Object findEnumNamingStrategy(MapperConfig<?> config2, AnnotatedClass ac) {
        EnumNaming ann = this._findAnnotation(ac, EnumNaming.class);
        return ann == null ? null : ann.value();
    }

    @Override
    public String findClassDescription(AnnotatedClass ac) {
        JsonClassDescription ann = this._findAnnotation(ac, JsonClassDescription.class);
        return ann == null ? null : ann.value();
    }

    @Override
    public VisibilityChecker<?> findAutoDetectVisibility(AnnotatedClass ac, VisibilityChecker<?> checker) {
        JsonAutoDetect ann = this._findAnnotation(ac, JsonAutoDetect.class);
        return ann == null ? checker : checker.with(ann);
    }

    @Override
    public String findImplicitPropertyName(AnnotatedMember m4) {
        PropertyName n = this._findConstructorName(m4);
        return n == null ? null : n.getSimpleName();
    }

    @Override
    public List<PropertyName> findPropertyAliases(Annotated m4) {
        JsonAlias ann = this._findAnnotation(m4, JsonAlias.class);
        if (ann == null) {
            return null;
        }
        String[] strs = ann.value();
        int len2 = strs.length;
        if (len2 == 0) {
            return Collections.emptyList();
        }
        ArrayList<PropertyName> result2 = new ArrayList<PropertyName>(len2);
        for (int i2 = 0; i2 < len2; ++i2) {
            result2.add(PropertyName.construct(strs[i2]));
        }
        return result2;
    }

    @Override
    public boolean hasIgnoreMarker(AnnotatedMember m4) {
        return this._isIgnorable(m4);
    }

    @Override
    public Boolean hasRequiredMarker(AnnotatedMember m4) {
        JsonProperty ann = this._findAnnotation(m4, JsonProperty.class);
        if (ann != null) {
            OptBoolean required = ann.isRequired();
            if (required != OptBoolean.DEFAULT) {
                return required.asBoolean();
            }
            return ann.required();
        }
        return null;
    }

    @Override
    public JsonProperty.Access findPropertyAccess(Annotated m4) {
        JsonProperty ann = this._findAnnotation(m4, JsonProperty.class);
        if (ann != null) {
            return ann.access();
        }
        return null;
    }

    @Override
    public String findPropertyDescription(Annotated ann) {
        JsonPropertyDescription desc = this._findAnnotation(ann, JsonPropertyDescription.class);
        return desc == null ? null : desc.value();
    }

    @Override
    public Integer findPropertyIndex(Annotated ann) {
        int ix;
        JsonProperty prop = this._findAnnotation(ann, JsonProperty.class);
        if (prop != null && (ix = prop.index()) != -1) {
            return ix;
        }
        return null;
    }

    @Override
    public String findPropertyDefaultValue(Annotated ann) {
        JsonProperty prop = this._findAnnotation(ann, JsonProperty.class);
        if (prop == null) {
            return null;
        }
        String str = prop.defaultValue();
        return str.isEmpty() ? null : str;
    }

    @Override
    public JsonFormat.Value findFormat(Annotated ann) {
        JsonFormat f2 = this._findAnnotation(ann, JsonFormat.class);
        return f2 == null ? null : JsonFormat.Value.from(f2);
    }

    @Override
    public AnnotationIntrospector.ReferenceProperty findReferenceType(AnnotatedMember member) {
        JsonManagedReference ref1 = this._findAnnotation(member, JsonManagedReference.class);
        if (ref1 != null) {
            return AnnotationIntrospector.ReferenceProperty.managed(ref1.value());
        }
        JsonBackReference ref2 = this._findAnnotation(member, JsonBackReference.class);
        if (ref2 != null) {
            return AnnotationIntrospector.ReferenceProperty.back(ref2.value());
        }
        return null;
    }

    @Override
    public NameTransformer findUnwrappingNameTransformer(AnnotatedMember member) {
        JsonUnwrapped ann = this._findAnnotation(member, JsonUnwrapped.class);
        if (ann == null || !ann.enabled()) {
            return null;
        }
        String prefix2 = ann.prefix();
        String suffix = ann.suffix();
        return NameTransformer.simpleTransformer(prefix2, suffix);
    }

    @Override
    public JacksonInject.Value findInjectableValue(AnnotatedMember m4) {
        JacksonInject ann = this._findAnnotation(m4, JacksonInject.class);
        if (ann == null) {
            return null;
        }
        JacksonInject.Value v = JacksonInject.Value.from(ann);
        if (!v.hasId()) {
            AnnotatedMethod am;
            String id = !(m4 instanceof AnnotatedMethod) ? m4.getRawType().getName() : ((am = (AnnotatedMethod)m4).getParameterCount() == 0 ? m4.getRawType().getName() : am.getRawParameterType(0).getName());
            v = v.withId(id);
        }
        return v;
    }

    @Override
    @Deprecated
    public Object findInjectableValueId(AnnotatedMember m4) {
        JacksonInject.Value v = this.findInjectableValue(m4);
        return v == null ? null : v.getId();
    }

    @Override
    public Class<?>[] findViews(Annotated a2) {
        JsonView ann = this._findAnnotation(a2, JsonView.class);
        return ann == null ? null : ann.value();
    }

    @Override
    public AnnotatedMethod resolveSetterConflict(MapperConfig<?> config2, AnnotatedMethod setter1, AnnotatedMethod setter2) {
        Class<?> cls1 = setter1.getRawParameterType(0);
        Class<?> cls2 = setter2.getRawParameterType(0);
        if (cls1.isPrimitive()) {
            if (!cls2.isPrimitive()) {
                return setter1;
            }
            return null;
        }
        if (cls2.isPrimitive()) {
            return setter2;
        }
        if (cls1 == String.class) {
            if (cls2 != String.class) {
                return setter1;
            }
        } else if (cls2 == String.class) {
            return setter2;
        }
        return null;
    }

    @Override
    public PropertyName findRenameByField(MapperConfig<?> config2, AnnotatedField f2, PropertyName implName) {
        return null;
    }

    @Override
    public JsonTypeInfo.Value findPolymorphicTypeInfo(MapperConfig<?> config2, Annotated ann) {
        JsonTypeInfo t2 = this._findAnnotation(ann, JsonTypeInfo.class);
        return t2 == null ? null : JsonTypeInfo.Value.from(t2);
    }

    @Override
    public TypeResolverBuilder<?> findTypeResolver(MapperConfig<?> config2, AnnotatedClass ac, JavaType baseType) {
        return this._findTypeResolver(config2, ac, baseType);
    }

    @Override
    public TypeResolverBuilder<?> findPropertyTypeResolver(MapperConfig<?> config2, AnnotatedMember am, JavaType baseType) {
        if (baseType.isContainerType() || baseType.isReferenceType()) {
            return null;
        }
        return this._findTypeResolver(config2, am, baseType);
    }

    @Override
    public TypeResolverBuilder<?> findPropertyContentTypeResolver(MapperConfig<?> config2, AnnotatedMember am, JavaType containerType) {
        if (containerType.getContentType() == null) {
            throw new IllegalArgumentException("Must call method with a container or reference type (got " + containerType + ")");
        }
        return this._findTypeResolver(config2, am, containerType);
    }

    @Override
    public List<NamedType> findSubtypes(Annotated a2) {
        JsonSubTypes t2 = this._findAnnotation(a2, JsonSubTypes.class);
        if (t2 == null) {
            return null;
        }
        JsonSubTypes.Type[] types = t2.value();
        if (t2.failOnRepeatedNames()) {
            return this.findSubtypesCheckRepeatedNames(a2.getName(), types);
        }
        ArrayList<NamedType> result2 = new ArrayList<NamedType>(types.length);
        for (JsonSubTypes.Type type2 : types) {
            result2.add(new NamedType(type2.value(), type2.name()));
            for (String name : type2.names()) {
                result2.add(new NamedType(type2.value(), name));
            }
        }
        return result2;
    }

    private List<NamedType> findSubtypesCheckRepeatedNames(String annotatedTypeName, JsonSubTypes.Type[] types) {
        ArrayList<NamedType> result2 = new ArrayList<NamedType>(types.length);
        HashSet<String> seenNames = new HashSet<String>();
        for (JsonSubTypes.Type type2 : types) {
            String typeName2 = type2.name();
            if (!typeName2.isEmpty() && seenNames.contains(typeName2)) {
                throw new IllegalArgumentException("Annotated type [" + annotatedTypeName + "] got repeated subtype name [" + typeName2 + "]");
            }
            seenNames.add(typeName2);
            result2.add(new NamedType(type2.value(), typeName2));
            for (String altName : type2.names()) {
                if (!altName.isEmpty() && seenNames.contains(altName)) {
                    throw new IllegalArgumentException("Annotated type [" + annotatedTypeName + "] got repeated subtype name [" + altName + "]");
                }
                seenNames.add(altName);
                result2.add(new NamedType(type2.value(), altName));
            }
        }
        return result2;
    }

    @Override
    public String findTypeName(AnnotatedClass ac) {
        JsonTypeName tn = this._findAnnotation(ac, JsonTypeName.class);
        return tn == null ? null : tn.value();
    }

    @Override
    public Boolean isTypeId(AnnotatedMember member) {
        return this._hasAnnotation(member, JsonTypeId.class);
    }

    @Override
    public ObjectIdInfo findObjectIdInfo(Annotated ann) {
        JsonIdentityInfo info = this._findAnnotation(ann, JsonIdentityInfo.class);
        if (info == null || info.generator() == ObjectIdGenerators.None.class) {
            return null;
        }
        PropertyName name = PropertyName.construct(info.property());
        return new ObjectIdInfo(name, info.scope(), info.generator(), info.resolver());
    }

    @Override
    public ObjectIdInfo findObjectReferenceInfo(Annotated ann, ObjectIdInfo objectIdInfo) {
        JsonIdentityReference ref = this._findAnnotation(ann, JsonIdentityReference.class);
        if (ref == null) {
            return objectIdInfo;
        }
        if (objectIdInfo == null) {
            objectIdInfo = ObjectIdInfo.empty();
        }
        return objectIdInfo.withAlwaysAsId(ref.alwaysAsId());
    }

    @Override
    public Object findSerializer(Annotated a2) {
        Class<? extends JsonSerializer> serClass;
        JsonSerialize ann = this._findAnnotation(a2, JsonSerialize.class);
        if (ann != null && (serClass = ann.using()) != JsonSerializer.None.class) {
            return serClass;
        }
        JsonRawValue annRaw = this._findAnnotation(a2, JsonRawValue.class);
        if (annRaw != null && annRaw.value()) {
            Class<?> cls = a2.getRawType();
            return new RawSerializer(cls);
        }
        return null;
    }

    @Override
    public Object findKeySerializer(Annotated a2) {
        Class<? extends JsonSerializer> serClass;
        JsonSerialize ann = this._findAnnotation(a2, JsonSerialize.class);
        if (ann != null && (serClass = ann.keyUsing()) != JsonSerializer.None.class) {
            return serClass;
        }
        return null;
    }

    @Override
    public Object findContentSerializer(Annotated a2) {
        Class<? extends JsonSerializer> serClass;
        JsonSerialize ann = this._findAnnotation(a2, JsonSerialize.class);
        if (ann != null && (serClass = ann.contentUsing()) != JsonSerializer.None.class) {
            return serClass;
        }
        return null;
    }

    @Override
    public Object findNullSerializer(Annotated a2) {
        Class<? extends JsonSerializer> serClass;
        JsonSerialize ann = this._findAnnotation(a2, JsonSerialize.class);
        if (ann != null && (serClass = ann.nullsUsing()) != JsonSerializer.None.class) {
            return serClass;
        }
        return null;
    }

    @Override
    public JsonInclude.Value findPropertyInclusion(Annotated a2) {
        JsonInclude.Value value2;
        JsonInclude inc = this._findAnnotation(a2, JsonInclude.class);
        JsonInclude.Value value3 = value2 = inc == null ? JsonInclude.Value.empty() : JsonInclude.Value.from(inc);
        if (value2.getValueInclusion() == JsonInclude.Include.USE_DEFAULTS) {
            value2 = this._refinePropertyInclusion(a2, value2);
        }
        return value2;
    }

    private JsonInclude.Value _refinePropertyInclusion(Annotated a2, JsonInclude.Value value2) {
        JsonSerialize ann = this._findAnnotation(a2, JsonSerialize.class);
        if (ann != null) {
            switch (ann.include()) {
                case ALWAYS: {
                    return value2.withValueInclusion(JsonInclude.Include.ALWAYS);
                }
                case NON_NULL: {
                    return value2.withValueInclusion(JsonInclude.Include.NON_NULL);
                }
                case NON_DEFAULT: {
                    return value2.withValueInclusion(JsonInclude.Include.NON_DEFAULT);
                }
                case NON_EMPTY: {
                    return value2.withValueInclusion(JsonInclude.Include.NON_EMPTY);
                }
            }
        }
        return value2;
    }

    @Override
    public JsonSerialize.Typing findSerializationTyping(Annotated a2) {
        JsonSerialize ann = this._findAnnotation(a2, JsonSerialize.class);
        return ann == null ? null : ann.typing();
    }

    @Override
    public Object findSerializationConverter(Annotated a2) {
        JsonSerialize ann = this._findAnnotation(a2, JsonSerialize.class);
        return ann == null ? null : this._classIfExplicit(ann.converter(), Converter.None.class);
    }

    @Override
    public Object findSerializationContentConverter(AnnotatedMember a2) {
        JsonSerialize ann = this._findAnnotation(a2, JsonSerialize.class);
        return ann == null ? null : this._classIfExplicit(ann.contentConverter(), Converter.None.class);
    }

    @Override
    public JavaType refineSerializationType(MapperConfig<?> config2, Annotated a2, JavaType baseType) throws JsonMappingException {
        JavaType contentType2;
        Class<?> currRaw;
        JsonSerialize jsonSer;
        TypeFactory tf;
        JavaType type2;
        block26: {
            Class<?> serClass;
            type2 = baseType;
            tf = config2.getTypeFactory();
            jsonSer = this._findAnnotation(a2, JsonSerialize.class);
            Class<?> clazz = serClass = jsonSer == null ? null : this._classIfExplicit(jsonSer.as());
            if (serClass != null) {
                if (type2.hasRawClass(serClass)) {
                    type2 = type2.withStaticTyping();
                } else {
                    Class<?> currRaw2 = type2.getRawClass();
                    try {
                        if (serClass.isAssignableFrom(currRaw2)) {
                            type2 = tf.constructGeneralizedType(type2, serClass);
                            break block26;
                        }
                        if (currRaw2.isAssignableFrom(serClass)) {
                            type2 = tf.constructSpecializedType(type2, serClass);
                            break block26;
                        }
                        if (this._primitiveAndWrapper(currRaw2, serClass)) {
                            type2 = type2.withStaticTyping();
                            break block26;
                        }
                        throw this._databindException(String.format("Cannot refine serialization type %s into %s; types not related", type2, serClass.getName()));
                    }
                    catch (IllegalArgumentException iae) {
                        throw this._databindException(iae, String.format("Failed to widen type %s with annotation (value %s), from '%s': %s", type2, serClass.getName(), a2.getName(), iae.getMessage()));
                    }
                }
            }
        }
        if (type2.isMapLikeType()) {
            Class<?> keyClass;
            JavaType keyType = type2.getKeyType();
            Class<?> clazz = keyClass = jsonSer == null ? null : this._classIfExplicit(jsonSer.keyAs());
            if (keyClass != null) {
                block27: {
                    if (keyType.hasRawClass(keyClass)) {
                        keyType = keyType.withStaticTyping();
                    } else {
                        currRaw = keyType.getRawClass();
                        try {
                            if (keyClass.isAssignableFrom(currRaw)) {
                                keyType = tf.constructGeneralizedType(keyType, keyClass);
                                break block27;
                            }
                            if (currRaw.isAssignableFrom(keyClass)) {
                                keyType = tf.constructSpecializedType(keyType, keyClass);
                                break block27;
                            }
                            if (this._primitiveAndWrapper(currRaw, keyClass)) {
                                keyType = keyType.withStaticTyping();
                                break block27;
                            }
                            throw this._databindException(String.format("Cannot refine serialization key type %s into %s; types not related", keyType, keyClass.getName()));
                        }
                        catch (IllegalArgumentException iae) {
                            throw this._databindException(iae, String.format("Failed to widen key type of %s with concrete-type annotation (value %s), from '%s': %s", type2, keyClass.getName(), a2.getName(), iae.getMessage()));
                        }
                    }
                }
                type2 = ((MapLikeType)type2).withKeyType(keyType);
            }
        }
        if ((contentType2 = type2.getContentType()) != null) {
            Class<?> contentClass;
            Class<?> clazz = contentClass = jsonSer == null ? null : this._classIfExplicit(jsonSer.contentAs());
            if (contentClass != null) {
                block28: {
                    if (contentType2.hasRawClass(contentClass)) {
                        contentType2 = contentType2.withStaticTyping();
                    } else {
                        currRaw = contentType2.getRawClass();
                        try {
                            if (contentClass.isAssignableFrom(currRaw)) {
                                contentType2 = tf.constructGeneralizedType(contentType2, contentClass);
                                break block28;
                            }
                            if (currRaw.isAssignableFrom(contentClass)) {
                                contentType2 = tf.constructSpecializedType(contentType2, contentClass);
                                break block28;
                            }
                            if (this._primitiveAndWrapper(currRaw, contentClass)) {
                                contentType2 = contentType2.withStaticTyping();
                                break block28;
                            }
                            throw this._databindException(String.format("Cannot refine serialization content type %s into %s; types not related", contentType2, contentClass.getName()));
                        }
                        catch (IllegalArgumentException iae) {
                            throw this._databindException(iae, String.format("Internal error: failed to refine value type of %s with concrete-type annotation (value %s), from '%s': %s", type2, contentClass.getName(), a2.getName(), iae.getMessage()));
                        }
                    }
                }
                type2 = type2.withContentType(contentType2);
            }
        }
        return type2;
    }

    @Override
    public String[] findSerializationPropertyOrder(AnnotatedClass ac) {
        JsonPropertyOrder order = this._findAnnotation(ac, JsonPropertyOrder.class);
        return order == null ? null : order.value();
    }

    @Override
    public Boolean findSerializationSortAlphabetically(Annotated ann) {
        return this._findSortAlpha(ann);
    }

    private final Boolean _findSortAlpha(Annotated ann) {
        JsonPropertyOrder order = this._findAnnotation(ann, JsonPropertyOrder.class);
        if (order != null && order.alphabetic()) {
            return Boolean.TRUE;
        }
        return null;
    }

    @Override
    public void findAndAddVirtualProperties(MapperConfig<?> config2, AnnotatedClass ac, List<BeanPropertyWriter> properties) {
        JsonAppend ann = this._findAnnotation(ac, JsonAppend.class);
        if (ann == null) {
            return;
        }
        boolean prepend = ann.prepend();
        JavaType propType = null;
        JsonAppend.Attr[] attrs = ann.attrs();
        int len2 = attrs.length;
        for (int i2 = 0; i2 < len2; ++i2) {
            if (propType == null) {
                propType = config2.constructType(Object.class);
            }
            BeanPropertyWriter bpw = this._constructVirtualProperty(attrs[i2], config2, ac, propType);
            if (prepend) {
                properties.add(i2, bpw);
                continue;
            }
            properties.add(bpw);
        }
        JsonAppend.Prop[] props = ann.props();
        int len3 = props.length;
        for (int i3 = 0; i3 < len3; ++i3) {
            BeanPropertyWriter bpw = this._constructVirtualProperty(props[i3], config2, ac);
            if (prepend) {
                properties.add(i3, bpw);
                continue;
            }
            properties.add(bpw);
        }
    }

    protected BeanPropertyWriter _constructVirtualProperty(JsonAppend.Attr attr, MapperConfig<?> config2, AnnotatedClass ac, JavaType type2) {
        PropertyMetadata metadata = attr.required() ? PropertyMetadata.STD_REQUIRED : PropertyMetadata.STD_OPTIONAL;
        String attrName = attr.value();
        PropertyName propName = this._propertyName(attr.propName(), attr.propNamespace());
        if (!propName.hasSimpleName()) {
            propName = PropertyName.construct(attrName);
        }
        VirtualAnnotatedMember member = new VirtualAnnotatedMember(ac, ac.getRawType(), attrName, type2);
        SimpleBeanPropertyDefinition propDef = SimpleBeanPropertyDefinition.construct(config2, (AnnotatedMember)member, propName, metadata, attr.include());
        return AttributePropertyWriter.construct(attrName, propDef, ac.getAnnotations(), type2);
    }

    protected BeanPropertyWriter _constructVirtualProperty(JsonAppend.Prop prop, MapperConfig<?> config2, AnnotatedClass ac) {
        VirtualBeanPropertyWriter bpw;
        PropertyMetadata metadata = prop.required() ? PropertyMetadata.STD_REQUIRED : PropertyMetadata.STD_OPTIONAL;
        PropertyName propName = this._propertyName(prop.name(), prop.namespace());
        JavaType type2 = config2.constructType(prop.type());
        VirtualAnnotatedMember member = new VirtualAnnotatedMember(ac, ac.getRawType(), propName.getSimpleName(), type2);
        SimpleBeanPropertyDefinition propDef = SimpleBeanPropertyDefinition.construct(config2, (AnnotatedMember)member, propName, metadata, prop.include());
        Class<? extends VirtualBeanPropertyWriter> implClass = prop.value();
        HandlerInstantiator hi = config2.getHandlerInstantiator();
        VirtualBeanPropertyWriter virtualBeanPropertyWriter = bpw = hi == null ? null : hi.virtualPropertyWriterInstance(config2, implClass);
        if (bpw == null) {
            bpw = ClassUtil.createInstance(implClass, config2.canOverrideAccessModifiers());
        }
        return bpw.withConfig(config2, ac, propDef, type2);
    }

    @Override
    public PropertyName findNameForSerialization(Annotated a2) {
        JsonProperty pann;
        boolean useDefault = false;
        JsonGetter jg = this._findAnnotation(a2, JsonGetter.class);
        if (jg != null) {
            String s2 = jg.value();
            if (!s2.isEmpty()) {
                return PropertyName.construct(s2);
            }
            useDefault = true;
        }
        if ((pann = this._findAnnotation(a2, JsonProperty.class)) != null) {
            String ns = pann.namespace();
            if (ns != null && ns.isEmpty()) {
                ns = null;
            }
            return PropertyName.construct(pann.value(), ns);
        }
        if (useDefault || this._hasOneOf(a2, ANNOTATIONS_TO_INFER_SER)) {
            return PropertyName.USE_DEFAULT;
        }
        return null;
    }

    @Override
    public Boolean hasAsKey(MapperConfig<?> config2, Annotated a2) {
        JsonKey ann = this._findAnnotation(a2, JsonKey.class);
        if (ann == null) {
            return null;
        }
        return ann.value();
    }

    @Override
    public Boolean hasAsValue(Annotated a2) {
        JsonValue ann = this._findAnnotation(a2, JsonValue.class);
        if (ann == null) {
            return null;
        }
        return ann.value();
    }

    @Override
    public Boolean hasAnyGetter(Annotated a2) {
        JsonAnyGetter ann = this._findAnnotation(a2, JsonAnyGetter.class);
        if (ann == null) {
            return null;
        }
        return ann.enabled();
    }

    @Override
    @Deprecated
    public boolean hasAnyGetterAnnotation(AnnotatedMethod am) {
        return this._hasAnnotation(am, JsonAnyGetter.class);
    }

    @Override
    @Deprecated
    public boolean hasAsValueAnnotation(AnnotatedMethod am) {
        JsonValue ann = this._findAnnotation(am, JsonValue.class);
        return ann != null && ann.value();
    }

    @Override
    public Object findDeserializer(Annotated a2) {
        Class<? extends JsonDeserializer> deserClass;
        JsonDeserialize ann = this._findAnnotation(a2, JsonDeserialize.class);
        if (ann != null && (deserClass = ann.using()) != JsonDeserializer.None.class) {
            return deserClass;
        }
        return null;
    }

    @Override
    public Object findKeyDeserializer(Annotated a2) {
        Class<? extends KeyDeserializer> deserClass;
        JsonDeserialize ann = this._findAnnotation(a2, JsonDeserialize.class);
        if (ann != null && (deserClass = ann.keyUsing()) != KeyDeserializer.None.class) {
            return deserClass;
        }
        return null;
    }

    @Override
    public Object findContentDeserializer(Annotated a2) {
        Class<? extends JsonDeserializer> deserClass;
        JsonDeserialize ann = this._findAnnotation(a2, JsonDeserialize.class);
        if (ann != null && (deserClass = ann.contentUsing()) != JsonDeserializer.None.class) {
            return deserClass;
        }
        return null;
    }

    @Override
    public Object findDeserializationConverter(Annotated a2) {
        JsonDeserialize ann = this._findAnnotation(a2, JsonDeserialize.class);
        return ann == null ? null : this._classIfExplicit(ann.converter(), Converter.None.class);
    }

    @Override
    public Object findDeserializationContentConverter(AnnotatedMember a2) {
        JsonDeserialize ann = this._findAnnotation(a2, JsonDeserialize.class);
        return ann == null ? null : this._classIfExplicit(ann.contentConverter(), Converter.None.class);
    }

    @Override
    public JavaType refineDeserializationType(MapperConfig<?> config2, Annotated a2, JavaType baseType) throws JsonMappingException {
        JavaType contentType2;
        Class<?> valueClass;
        JavaType type2 = baseType;
        TypeFactory tf = config2.getTypeFactory();
        JsonDeserialize jsonDeser = this._findAnnotation(a2, JsonDeserialize.class);
        Class<?> clazz = valueClass = jsonDeser == null ? null : this._classIfExplicit(jsonDeser.as());
        if (valueClass != null && !type2.hasRawClass(valueClass) && !this._primitiveAndWrapper(type2, valueClass)) {
            try {
                type2 = tf.constructSpecializedType(type2, valueClass);
            }
            catch (IllegalArgumentException iae) {
                throw this._databindException(iae, String.format("Failed to narrow type %s with annotation (value %s), from '%s': %s", type2, valueClass.getName(), a2.getName(), iae.getMessage()));
            }
        }
        if (type2.isMapLikeType()) {
            Class<?> keyClass;
            JavaType keyType = type2.getKeyType();
            Class<?> clazz2 = keyClass = jsonDeser == null ? null : this._classIfExplicit(jsonDeser.keyAs());
            if (keyClass != null && !this._primitiveAndWrapper(keyType, keyClass)) {
                try {
                    keyType = tf.constructSpecializedType(keyType, keyClass);
                    type2 = ((MapLikeType)type2).withKeyType(keyType);
                }
                catch (IllegalArgumentException iae) {
                    throw this._databindException(iae, String.format("Failed to narrow key type of %s with concrete-type annotation (value %s), from '%s': %s", type2, keyClass.getName(), a2.getName(), iae.getMessage()));
                }
            }
        }
        if ((contentType2 = type2.getContentType()) != null) {
            Class<?> contentClass;
            Class<?> clazz3 = contentClass = jsonDeser == null ? null : this._classIfExplicit(jsonDeser.contentAs());
            if (contentClass != null && !this._primitiveAndWrapper(contentType2, contentClass)) {
                try {
                    contentType2 = tf.constructSpecializedType(contentType2, contentClass);
                    type2 = type2.withContentType(contentType2);
                }
                catch (IllegalArgumentException iae) {
                    throw this._databindException(iae, String.format("Failed to narrow value type of %s with concrete-type annotation (value %s), from '%s': %s", type2, contentClass.getName(), a2.getName(), iae.getMessage()));
                }
            }
        }
        return type2;
    }

    @Override
    public Object findValueInstantiator(AnnotatedClass ac) {
        JsonValueInstantiator ann = this._findAnnotation(ac, JsonValueInstantiator.class);
        return ann == null ? null : ann.value();
    }

    @Override
    public Class<?> findPOJOBuilder(AnnotatedClass ac) {
        JsonDeserialize ann = this._findAnnotation(ac, JsonDeserialize.class);
        return ann == null ? null : this._classIfExplicit(ann.builder());
    }

    @Override
    public JsonPOJOBuilder.Value findPOJOBuilderConfig(AnnotatedClass ac) {
        JsonPOJOBuilder ann = this._findAnnotation(ac, JsonPOJOBuilder.class);
        return ann == null ? null : new JsonPOJOBuilder.Value(ann);
    }

    @Override
    public PropertyName findNameForDeserialization(Annotated a2) {
        JsonProperty pann;
        boolean useDefault = false;
        JsonSetter js = this._findAnnotation(a2, JsonSetter.class);
        if (js != null) {
            String s2 = js.value();
            if (s2.isEmpty()) {
                useDefault = true;
            } else {
                return PropertyName.construct(s2);
            }
        }
        if ((pann = this._findAnnotation(a2, JsonProperty.class)) != null) {
            String ns = pann.namespace();
            if (ns != null && ns.isEmpty()) {
                ns = null;
            }
            return PropertyName.construct(pann.value(), ns);
        }
        if (useDefault || this._hasOneOf(a2, ANNOTATIONS_TO_INFER_DESER)) {
            return PropertyName.USE_DEFAULT;
        }
        return null;
    }

    @Override
    public Boolean hasAnySetter(Annotated a2) {
        JsonAnySetter ann = this._findAnnotation(a2, JsonAnySetter.class);
        return ann == null ? null : Boolean.valueOf(ann.enabled());
    }

    @Override
    public JsonSetter.Value findSetterInfo(Annotated a2) {
        return JsonSetter.Value.from(this._findAnnotation(a2, JsonSetter.class));
    }

    @Override
    public Boolean findMergeInfo(Annotated a2) {
        JsonMerge ann = this._findAnnotation(a2, JsonMerge.class);
        return ann == null ? null : ann.value().asBoolean();
    }

    @Override
    @Deprecated
    public boolean hasAnySetterAnnotation(AnnotatedMethod am) {
        return this._hasAnnotation(am, JsonAnySetter.class);
    }

    @Override
    @Deprecated
    public boolean hasCreatorAnnotation(Annotated a2) {
        Boolean b2;
        JsonCreator ann = this._findAnnotation(a2, JsonCreator.class);
        if (ann != null) {
            return ann.mode() != JsonCreator.Mode.DISABLED;
        }
        if (this._cfgConstructorPropertiesImpliesCreator && a2 instanceof AnnotatedConstructor && _java7Helper != null && (b2 = _java7Helper.hasCreatorAnnotation(a2)) != null) {
            return b2;
        }
        return false;
    }

    @Override
    @Deprecated
    public JsonCreator.Mode findCreatorBinding(Annotated a2) {
        JsonCreator ann = this._findAnnotation(a2, JsonCreator.class);
        return ann == null ? null : ann.mode();
    }

    @Override
    public JsonCreator.Mode findCreatorAnnotation(MapperConfig<?> config2, Annotated a2) {
        Boolean b2;
        JsonCreator.Mode mode;
        JsonCreator ann = this._findAnnotation(a2, JsonCreator.class);
        if (ann == null) {
            mode = null;
        } else {
            mode = ann.mode();
            if (mode != JsonCreator.Mode.DEFAULT) {
                return mode;
            }
        }
        if (this._cfgConstructorPropertiesImpliesCreator && config2.isEnabled(MapperFeature.INFER_CREATOR_FROM_CONSTRUCTOR_PROPERTIES) && a2 instanceof AnnotatedConstructor && _java7Helper != null && (b2 = _java7Helper.hasCreatorAnnotation(a2)) != null && b2.booleanValue()) {
            return JsonCreator.Mode.PROPERTIES;
        }
        return mode;
    }

    protected boolean _isIgnorable(Annotated a2) {
        Boolean b2;
        JsonIgnore ann = this._findAnnotation(a2, JsonIgnore.class);
        if (ann != null) {
            return ann.value();
        }
        if (_java7Helper != null && (b2 = _java7Helper.findTransient(a2)) != null) {
            return b2;
        }
        return false;
    }

    protected Class<?> _classIfExplicit(Class<?> cls) {
        if (cls == null || ClassUtil.isBogusClass(cls)) {
            return null;
        }
        return cls;
    }

    protected Class<?> _classIfExplicit(Class<?> cls, Class<?> implicit) {
        return (cls = this._classIfExplicit(cls)) == null || cls == implicit ? null : cls;
    }

    protected PropertyName _propertyName(String localName, String namespace) {
        if (localName.isEmpty()) {
            return PropertyName.USE_DEFAULT;
        }
        if (namespace == null || namespace.isEmpty()) {
            return PropertyName.construct(localName);
        }
        return PropertyName.construct(localName, namespace);
    }

    protected PropertyName _findConstructorName(Annotated a2) {
        PropertyName name;
        AnnotatedParameter p;
        AnnotatedWithParams ctor;
        if (a2 instanceof AnnotatedParameter && (ctor = (p = (AnnotatedParameter)a2).getOwner()) != null && _java7Helper != null && (name = _java7Helper.findConstructorName(p)) != null) {
            return name;
        }
        return null;
    }

    protected TypeResolverBuilder<?> _findTypeResolver(MapperConfig<?> config2, Annotated ann, JavaType baseType) {
        Class<?> defaultImpl;
        JsonTypeInfo.As inclusion;
        TypeIdResolver idRes;
        TypeResolverBuilder<?> b2;
        JsonTypeInfo.Value typeInfo = this.findPolymorphicTypeInfo(config2, ann);
        JsonTypeResolver resAnn = this._findAnnotation(ann, JsonTypeResolver.class);
        if (resAnn != null) {
            if (typeInfo == null) {
                return null;
            }
            b2 = config2.typeResolverBuilderInstance(ann, resAnn.value());
        } else {
            if (typeInfo == null) {
                return null;
            }
            if (typeInfo.getIdType() == JsonTypeInfo.Id.NONE) {
                return this._constructNoTypeResolverBuilder();
            }
            b2 = this._constructStdTypeResolverBuilder(config2, typeInfo, baseType);
        }
        JsonTypeIdResolver idResInfo = this._findAnnotation(ann, JsonTypeIdResolver.class);
        TypeIdResolver typeIdResolver = idRes = idResInfo == null ? null : config2.typeIdResolverInstance(ann, idResInfo.value());
        if (idRes != null) {
            idRes.init(baseType);
        }
        if ((inclusion = typeInfo.getInclusionType()) == JsonTypeInfo.As.EXTERNAL_PROPERTY && ann instanceof AnnotatedClass) {
            typeInfo = typeInfo.withInclusionType(JsonTypeInfo.As.PROPERTY);
        }
        if ((defaultImpl = typeInfo.getDefaultImpl()) != null && defaultImpl != JsonTypeInfo.None.class && !defaultImpl.isAnnotation()) {
            typeInfo = typeInfo.withDefaultImpl(defaultImpl);
        }
        b2 = b2.init(typeInfo, idRes);
        return b2;
    }

    protected StdTypeResolverBuilder _constructStdTypeResolverBuilder() {
        return new StdTypeResolverBuilder();
    }

    protected TypeResolverBuilder<?> _constructStdTypeResolverBuilder(MapperConfig<?> config2, JsonTypeInfo.Value typeInfo, JavaType baseType) {
        return new StdTypeResolverBuilder(typeInfo);
    }

    protected StdTypeResolverBuilder _constructNoTypeResolverBuilder() {
        return StdTypeResolverBuilder.noTypeInfoBuilder();
    }

    private boolean _primitiveAndWrapper(Class<?> baseType, Class<?> refinement) {
        if (baseType.isPrimitive()) {
            return baseType == ClassUtil.primitiveType(refinement);
        }
        if (refinement.isPrimitive()) {
            return refinement == ClassUtil.primitiveType(baseType);
        }
        return false;
    }

    private boolean _primitiveAndWrapper(JavaType baseType, Class<?> refinement) {
        if (baseType.isPrimitive()) {
            return baseType.hasRawClass(ClassUtil.primitiveType(refinement));
        }
        if (refinement.isPrimitive()) {
            return refinement == ClassUtil.primitiveType(baseType.getRawClass());
        }
        return false;
    }

    private JsonMappingException _databindException(String msg) {
        return new JsonMappingException(null, msg);
    }

    private JsonMappingException _databindException(Throwable t2, String msg) {
        return new JsonMappingException(null, msg, t2);
    }

    static {
        Java7Support x = null;
        try {
            x = Java7Support.instance();
        }
        catch (Throwable t2) {
            ExceptionUtil.rethrowIfFatal(t2);
        }
        _java7Helper = x;
    }
}

