/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.PropertyFilter;
import com.fasterxml.jackson.databind.ser.std.MapSerializer;
import java.io.Serializable;
import java.util.Map;

public class AnyGetterWriter
extends BeanPropertyWriter
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final BeanProperty _property;
    protected final AnnotatedMember _accessor;
    protected JsonSerializer<Object> _serializer;
    protected MapSerializer _mapSerializer;

    public AnyGetterWriter(BeanPropertyWriter parent, BeanProperty property2, AnnotatedMember accessor, JsonSerializer<?> serializer2) {
        super(parent);
        this._accessor = accessor;
        this._property = property2;
        this._serializer = serializer2;
        if (serializer2 instanceof MapSerializer) {
            this._mapSerializer = (MapSerializer)serializer2;
        }
    }

    @Deprecated
    public AnyGetterWriter(BeanProperty property2, AnnotatedMember accessor, JsonSerializer<?> serializer2) {
        this(null, property2, accessor, serializer2);
    }

    @Override
    public void fixAccess(SerializationConfig config2) {
        this._accessor.fixAccess(config2.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
    }

    public void getAndSerialize(Object bean, JsonGenerator gen, SerializerProvider provider2) throws Exception {
        Object value2 = this._accessor.getValue(bean);
        if (value2 == null) {
            return;
        }
        if (!(value2 instanceof Map)) {
            provider2.reportBadDefinition(this._property.getType(), String.format("Value returned by 'any-getter' %s() not java.util.Map but %s", this._accessor.getName(), value2.getClass().getName()));
        }
        if (this._mapSerializer != null) {
            this._mapSerializer.serializeWithoutTypeInfo((Map)value2, gen, provider2);
            return;
        }
        this._serializer.serialize(value2, gen, provider2);
    }

    @Override
    public void serializeAsField(Object bean, JsonGenerator gen, SerializerProvider prov) throws Exception {
        this.getAndSerialize(bean, gen, prov);
    }

    public void getAndFilter(Object bean, JsonGenerator gen, SerializerProvider provider2, PropertyFilter filter2) throws Exception {
        Object value2 = this._accessor.getValue(bean);
        if (value2 == null) {
            return;
        }
        if (!(value2 instanceof Map)) {
            provider2.reportBadDefinition(this._property.getType(), String.format("Value returned by 'any-getter' (%s()) not java.util.Map but %s", this._accessor.getName(), value2.getClass().getName()));
        }
        if (this._mapSerializer != null) {
            this._mapSerializer.serializeFilteredAnyProperties(provider2, gen, bean, (Map)value2, filter2, null);
            return;
        }
        this._serializer.serialize(value2, gen, provider2);
    }

    public void resolve(SerializerProvider provider2) throws JsonMappingException {
        if (this._serializer instanceof ContextualSerializer) {
            JsonSerializer<?> ser = provider2.handlePrimaryContextualization(this._serializer, this._property);
            this._serializer = ser;
            if (ser instanceof MapSerializer) {
                this._mapSerializer = (MapSerializer)ser;
            }
        }
    }
}

