/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.impl;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.fasterxml.jackson.databind.ser.std.AsArraySerializerBase;
import java.io.IOException;
import java.util.List;

@JacksonStdImpl
public final class IndexedListSerializer
extends AsArraySerializerBase<List<?>> {
    private static final long serialVersionUID = 1L;

    public IndexedListSerializer(JavaType elemType, boolean staticTyping, TypeSerializer vts, JsonSerializer<Object> valueSerializer) {
        super(List.class, elemType, staticTyping, vts, valueSerializer);
    }

    public IndexedListSerializer(IndexedListSerializer src, BeanProperty property2, TypeSerializer vts, JsonSerializer<?> valueSerializer, Boolean unwrapSingle) {
        super(src, property2, vts, valueSerializer, unwrapSingle);
    }

    public IndexedListSerializer withResolved(BeanProperty property2, TypeSerializer vts, JsonSerializer<?> elementSerializer, Boolean unwrapSingle) {
        return new IndexedListSerializer(this, property2, vts, elementSerializer, unwrapSingle);
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, List<?> value2) {
        return value2.isEmpty();
    }

    @Override
    public boolean hasSingleElement(List<?> value2) {
        return value2.size() == 1;
    }

    @Override
    public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
        return new IndexedListSerializer(this, this._property, vts, this._elementSerializer, this._unwrapSingle);
    }

    @Override
    public final void serialize(List<?> value2, JsonGenerator gen, SerializerProvider provider2) throws IOException {
        int len2 = value2.size();
        if (len2 == 1 && (this._unwrapSingle == null && provider2.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED) || this._unwrapSingle == Boolean.TRUE)) {
            this.serializeContents(value2, gen, provider2);
            return;
        }
        gen.writeStartArray(value2, len2);
        this.serializeContents(value2, gen, provider2);
        gen.writeEndArray();
    }

    @Override
    public void serializeContents(List<?> value2, JsonGenerator g2, SerializerProvider provider2) throws IOException {
        int i2;
        if (this._elementSerializer != null) {
            this.serializeContentsUsing(value2, g2, provider2, this._elementSerializer);
            return;
        }
        if (this._valueTypeSerializer != null) {
            this.serializeTypedContents(value2, g2, provider2);
            return;
        }
        int len2 = value2.size();
        if (len2 == 0) {
            return;
        }
        try {
            PropertySerializerMap serializers = this._dynamicSerializers;
            for (i2 = 0; i2 < len2; ++i2) {
                Object elem = value2.get(i2);
                if (elem == null) {
                    provider2.defaultSerializeNull(g2);
                    continue;
                }
                Class<?> cc = elem.getClass();
                JsonSerializer<Object> serializer2 = serializers.serializerFor(cc);
                if (serializer2 == null) {
                    serializer2 = this._elementType.hasGenericTypes() ? this._findAndAddDynamic(serializers, provider2.constructSpecializedType(this._elementType, cc), provider2) : this._findAndAddDynamic(serializers, cc, provider2);
                    serializers = this._dynamicSerializers;
                }
                serializer2.serialize(elem, g2, provider2);
            }
        }
        catch (Exception e2) {
            this.wrapAndThrow(provider2, (Throwable)e2, value2, i2);
        }
    }

    public void serializeContentsUsing(List<?> value2, JsonGenerator jgen, SerializerProvider provider2, JsonSerializer<Object> ser) throws IOException {
        int len2 = value2.size();
        if (len2 == 0) {
            return;
        }
        TypeSerializer typeSer = this._valueTypeSerializer;
        for (int i2 = 0; i2 < len2; ++i2) {
            Object elem = value2.get(i2);
            try {
                if (elem == null) {
                    provider2.defaultSerializeNull(jgen);
                    continue;
                }
                if (typeSer == null) {
                    ser.serialize(elem, jgen, provider2);
                    continue;
                }
                ser.serializeWithType(elem, jgen, provider2, typeSer);
                continue;
            }
            catch (Exception e2) {
                this.wrapAndThrow(provider2, (Throwable)e2, value2, i2);
            }
        }
    }

    public void serializeTypedContents(List<?> value2, JsonGenerator jgen, SerializerProvider provider2) throws IOException {
        int i2;
        int len2 = value2.size();
        if (len2 == 0) {
            return;
        }
        try {
            TypeSerializer typeSer = this._valueTypeSerializer;
            PropertySerializerMap serializers = this._dynamicSerializers;
            for (i2 = 0; i2 < len2; ++i2) {
                Object elem = value2.get(i2);
                if (elem == null) {
                    provider2.defaultSerializeNull(jgen);
                    continue;
                }
                Class<?> cc = elem.getClass();
                JsonSerializer<Object> serializer2 = serializers.serializerFor(cc);
                if (serializer2 == null) {
                    serializer2 = this._elementType.hasGenericTypes() ? this._findAndAddDynamic(serializers, provider2.constructSpecializedType(this._elementType, cc), provider2) : this._findAndAddDynamic(serializers, cc, provider2);
                    serializers = this._dynamicSerializers;
                }
                serializer2.serializeWithType(elem, jgen, provider2, typeSer);
            }
        }
        catch (Exception e2) {
            this.wrapAndThrow(provider2, (Throwable)e2, value2, i2);
        }
    }
}

