/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.impl;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.ArraySerializerBase;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Objects;

@JacksonStdImpl
public class StringArraySerializer
extends ArraySerializerBase<String[]>
implements ContextualSerializer {
    private static final JavaType VALUE_TYPE = TypeFactory.defaultInstance().uncheckedSimpleType(String.class);
    public static final StringArraySerializer instance = new StringArraySerializer();
    protected final JsonSerializer<Object> _elementSerializer;

    protected StringArraySerializer() {
        super(String[].class);
        this._elementSerializer = null;
    }

    public StringArraySerializer(StringArraySerializer src, BeanProperty prop, JsonSerializer<?> ser, Boolean unwrapSingle) {
        super(src, prop, unwrapSingle);
        this._elementSerializer = ser;
    }

    @Override
    public JsonSerializer<?> _withResolved(BeanProperty prop, Boolean unwrapSingle) {
        return new StringArraySerializer(this, prop, this._elementSerializer, unwrapSingle);
    }

    @Override
    public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
        return this;
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider provider2, BeanProperty property2) throws JsonMappingException {
        JsonSerializer<Object> ser = null;
        if (property2 != null) {
            Object serDef;
            AnnotationIntrospector ai = provider2.getAnnotationIntrospector();
            AnnotatedMember m4 = property2.getMember();
            if (m4 != null && (serDef = ai.findContentSerializer(m4)) != null) {
                ser = provider2.serializerInstance(m4, serDef);
            }
        }
        Boolean unwrapSingle = this.findFormatFeature(provider2, property2, String[].class, JsonFormat.Feature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED);
        if (ser == null) {
            ser = this._elementSerializer;
        }
        if ((ser = this.findContextualConvertingSerializer(provider2, property2, ser)) == null) {
            ser = provider2.findContentValueSerializer(String.class, property2);
        }
        if (this.isDefaultSerializer(ser)) {
            ser = null;
        }
        if (ser == this._elementSerializer && Objects.equals(unwrapSingle, this._unwrapSingle)) {
            return this;
        }
        return new StringArraySerializer(this, property2, ser, unwrapSingle);
    }

    @Override
    public JavaType getContentType() {
        return VALUE_TYPE;
    }

    @Override
    public JsonSerializer<?> getContentSerializer() {
        return this._elementSerializer;
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, String[] value2) {
        return value2.length == 0;
    }

    @Override
    public boolean hasSingleElement(String[] value2) {
        return value2.length == 1;
    }

    @Override
    public final void serialize(String[] value2, JsonGenerator gen, SerializerProvider provider2) throws IOException {
        int len2 = value2.length;
        if (len2 == 1 && (this._unwrapSingle == null && provider2.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED) || this._unwrapSingle == Boolean.TRUE)) {
            this.serializeContents(value2, gen, provider2);
            return;
        }
        gen.writeStartArray(value2, len2);
        this.serializeContents(value2, gen, provider2);
        gen.writeEndArray();
    }

    @Override
    public void serializeContents(String[] value2, JsonGenerator gen, SerializerProvider provider2) throws IOException {
        int len2 = value2.length;
        if (len2 == 0) {
            return;
        }
        if (this._elementSerializer != null) {
            this.serializeContentsSlow(value2, gen, provider2, this._elementSerializer);
            return;
        }
        for (int i2 = 0; i2 < len2; ++i2) {
            String str = value2[i2];
            if (str == null) {
                gen.writeNull();
                continue;
            }
            gen.writeString(value2[i2]);
        }
    }

    private void serializeContentsSlow(String[] value2, JsonGenerator gen, SerializerProvider provider2, JsonSerializer<Object> ser) throws IOException {
        int len2 = value2.length;
        for (int i2 = 0; i2 < len2; ++i2) {
            String str = value2[i2];
            if (str == null) {
                provider2.defaultSerializeNull(gen);
                continue;
            }
            ser.serialize(value2[i2], gen, provider2);
        }
    }

    @Override
    @Deprecated
    public JsonNode getSchema(SerializerProvider provider2, Type typeHint) {
        return this.createSchemaNode("array", true).set("items", this.createSchemaNode("string"));
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor2, JavaType typeHint) throws JsonMappingException {
        this.visitArrayFormat(visitor2, typeHint, JsonFormatTypes.STRING);
    }
}

