/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.fasterxml.jackson.databind.ser.std.AsArraySerializerBase;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;

public class CollectionSerializer
extends AsArraySerializerBase<Collection<?>> {
    private static final long serialVersionUID = 1L;
    private final boolean _maybeEnumSet;

    public CollectionSerializer(JavaType elemType, boolean staticTyping, TypeSerializer vts, JsonSerializer<Object> valueSerializer) {
        super(Collection.class, elemType, staticTyping, vts, valueSerializer);
        this._maybeEnumSet = elemType.isEnumType() || elemType.isJavaLangObject();
    }

    public CollectionSerializer(CollectionSerializer src, BeanProperty property2, TypeSerializer vts, JsonSerializer<?> valueSerializer, Boolean unwrapSingle) {
        super(src, property2, vts, valueSerializer, unwrapSingle);
        this._maybeEnumSet = src._maybeEnumSet;
    }

    @Override
    public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
        return new CollectionSerializer(this, this._property, vts, this._elementSerializer, this._unwrapSingle);
    }

    public CollectionSerializer withResolved(BeanProperty property2, TypeSerializer vts, JsonSerializer<?> elementSerializer, Boolean unwrapSingle) {
        return new CollectionSerializer(this, property2, vts, elementSerializer, unwrapSingle);
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, Collection<?> value2) {
        return value2.isEmpty();
    }

    @Override
    public boolean hasSingleElement(Collection<?> value2) {
        return value2.size() == 1;
    }

    @Override
    public final void serialize(Collection<?> value2, JsonGenerator g2, SerializerProvider provider2) throws IOException {
        int len2 = value2.size();
        if (len2 == 1 && (this._unwrapSingle == null && provider2.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED) || this._unwrapSingle == Boolean.TRUE)) {
            this.serializeContents(value2, g2, provider2);
            return;
        }
        g2.writeStartArray(value2, len2);
        this.serializeContents(value2, g2, provider2);
        g2.writeEndArray();
    }

    @Override
    public void serializeContents(Collection<?> value2, JsonGenerator g2, SerializerProvider provider2) throws IOException {
        g2.assignCurrentValue(value2);
        if (this._elementSerializer != null) {
            this.serializeContentsUsing(value2, g2, provider2, this._elementSerializer);
            return;
        }
        Iterator<?> it = value2.iterator();
        if (!it.hasNext()) {
            return;
        }
        PropertySerializerMap serializers = this._dynamicSerializers;
        TypeSerializer typeSer = this._maybeEnumSet && value2 instanceof EnumSet ? null : this._valueTypeSerializer;
        int i2 = 0;
        try {
            do {
                Object elem;
                if ((elem = it.next()) == null) {
                    provider2.defaultSerializeNull(g2);
                } else {
                    Class<?> cc = elem.getClass();
                    JsonSerializer<Object> serializer2 = serializers.serializerFor(cc);
                    if (serializer2 == null) {
                        serializer2 = this._elementType.hasGenericTypes() ? this._findAndAddDynamic(serializers, provider2.constructSpecializedType(this._elementType, cc), provider2) : this._findAndAddDynamic(serializers, cc, provider2);
                        serializers = this._dynamicSerializers;
                    }
                    if (typeSer == null) {
                        serializer2.serialize(elem, g2, provider2);
                    } else {
                        serializer2.serializeWithType(elem, g2, provider2, typeSer);
                    }
                }
                ++i2;
            } while (it.hasNext());
        }
        catch (Exception e2) {
            this.wrapAndThrow(provider2, (Throwable)e2, value2, i2);
        }
    }

    public void serializeContentsUsing(Collection<?> value2, JsonGenerator g2, SerializerProvider provider2, JsonSerializer<Object> ser) throws IOException {
        Iterator<?> it = value2.iterator();
        if (it.hasNext()) {
            TypeSerializer typeSer = this._maybeEnumSet && value2 instanceof EnumSet ? null : this._valueTypeSerializer;
            int i2 = 0;
            do {
                Object elem = it.next();
                try {
                    if (elem == null) {
                        provider2.defaultSerializeNull(g2);
                    } else if (typeSer == null) {
                        ser.serialize(elem, g2, provider2);
                    } else {
                        ser.serializeWithType(elem, g2, provider2, typeSer);
                    }
                    ++i2;
                }
                catch (Exception e2) {
                    this.wrapAndThrow(provider2, (Throwable)e2, value2, i2);
                }
            } while (it.hasNext());
        }
    }
}

