/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.AsArraySerializerBase;
import java.io.IOException;
import java.util.EnumSet;

public class EnumSetSerializer
extends AsArraySerializerBase<EnumSet<? extends Enum<?>>> {
    public EnumSetSerializer(JavaType elemType) {
        super(EnumSet.class, elemType, true, null, null);
    }

    public EnumSetSerializer(EnumSetSerializer src, BeanProperty property2, TypeSerializer vts, JsonSerializer<?> valueSerializer, Boolean unwrapSingle) {
        super(src, property2, vts, valueSerializer, unwrapSingle);
    }

    public EnumSetSerializer _withValueTypeSerializer(TypeSerializer vts) {
        return this;
    }

    public EnumSetSerializer withResolved(BeanProperty property2, TypeSerializer vts, JsonSerializer<?> elementSerializer, Boolean unwrapSingle) {
        return new EnumSetSerializer(this, property2, vts, elementSerializer, unwrapSingle);
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, EnumSet<? extends Enum<?>> value2) {
        return value2.isEmpty();
    }

    @Override
    public boolean hasSingleElement(EnumSet<? extends Enum<?>> value2) {
        return value2.size() == 1;
    }

    @Override
    public void serialize(EnumSet<? extends Enum<?>> value2, JsonGenerator gen, SerializerProvider provider2) throws IOException {
        int len2 = value2.size();
        if (len2 == 1 && (this._unwrapSingle == null && provider2.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED) || this._unwrapSingle == Boolean.TRUE)) {
            this.serializeContents(value2, gen, provider2);
            return;
        }
        gen.writeStartArray(value2, len2);
        this.serializeContents(value2, gen, provider2);
        gen.writeEndArray();
    }

    @Override
    public void serializeContents(EnumSet<? extends Enum<?>> value2, JsonGenerator gen, SerializerProvider provider2) throws IOException {
        gen.assignCurrentValue(value2);
        JsonSerializer<Object> enumSer = this._elementSerializer;
        for (Enum enum_ : value2) {
            if (enumSer == null) {
                enumSer = provider2.findContentValueSerializer(enum_.getDeclaringClass(), this._property);
            }
            enumSer.serialize(enum_, gen, provider2);
        }
    }
}

