/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.ArraySerializerBase;
import com.fasterxml.jackson.databind.ser.std.ByteArraySerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;

public class StdArraySerializers {
    protected static final HashMap<String, JsonSerializer<?>> _arraySerializers = new HashMap();

    protected StdArraySerializers() {
    }

    public static JsonSerializer<?> findStandardImpl(Class<?> cls) {
        return _arraySerializers.get(cls.getName());
    }

    static JavaType simpleElementType(Class<?> elemClass) {
        return TypeFactory.defaultInstance().uncheckedSimpleType(elemClass);
    }

    static {
        _arraySerializers.put(boolean[].class.getName(), new BooleanArraySerializer());
        _arraySerializers.put(byte[].class.getName(), new ByteArraySerializer());
        _arraySerializers.put(char[].class.getName(), new CharArraySerializer());
        _arraySerializers.put(short[].class.getName(), new ShortArraySerializer());
        _arraySerializers.put(int[].class.getName(), new IntArraySerializer());
        _arraySerializers.put(long[].class.getName(), new LongArraySerializer());
        _arraySerializers.put(float[].class.getName(), new FloatArraySerializer());
        _arraySerializers.put(double[].class.getName(), new DoubleArraySerializer());
    }

    @JacksonStdImpl
    public static class BinaryDoubleArraySerializer
    extends StdSerializer<double[]>
    implements ContextualSerializer {
        private static final long serialVersionUID = 1L;
        static final BinaryDoubleArraySerializer instance = new BinaryDoubleArraySerializer();

        public BinaryDoubleArraySerializer() {
            super(double[].class);
        }

        @Override
        public boolean isEmpty(SerializerProvider prov, double[] value2) {
            return value2.length == 0;
        }

        @Override
        public JsonSerializer<?> createContextual(SerializerProvider ctxt, BeanProperty property2) throws JsonMappingException {
            JsonFormat.Value format2 = this.findFormatOverrides(ctxt, property2, this.handledType());
            if (format2 != null) {
                switch (format2.getShape()) {
                    case ARRAY: 
                    case NATURAL: {
                        return DoubleArraySerializer.instance;
                    }
                }
            }
            return this;
        }

        @Override
        public void serialize(double[] value2, JsonGenerator g2, SerializerProvider ctxt) throws IOException {
            int vectorLen = value2.length;
            byte[] b2 = new byte[vectorLen << 3];
            int out2 = 0;
            for (int i2 = 0; i2 < vectorLen; ++i2) {
                long bits = Double.doubleToLongBits(value2[i2]);
                int hi = (int)(bits >> 32);
                b2[out2] = (byte)(hi >> 24);
                b2[out2 + 1] = (byte)(hi >> 16);
                b2[out2 + 2] = (byte)(hi >> 8);
                b2[out2 + 3] = (byte)hi;
                int lo = (int)bits;
                b2[out2 + 4] = (byte)(lo >> 24);
                b2[out2 + 5] = (byte)(lo >> 16);
                b2[out2 + 6] = (byte)(lo >> 8);
                b2[out2 + 7] = (byte)lo;
                out2 += 8;
            }
            g2.writeBinary(ctxt.getConfig().getBase64Variant(), b2, 0, b2.length);
        }

        @Override
        public void serializeWithType(double[] value2, JsonGenerator g2, SerializerProvider ctxt, TypeSerializer typeSer) throws IOException {
            WritableTypeId typeIdDef = typeSer.writeTypePrefix(g2, typeSer.typeId(value2, JsonToken.VALUE_EMBEDDED_OBJECT));
            this.serialize(value2, g2, ctxt);
            typeSer.writeTypeSuffix(g2, typeIdDef);
        }

        @Override
        @Deprecated
        public JsonNode getSchema(SerializerProvider provider2, Type typeHint) {
            return this.createSchemaNode("array", true).set("items", this.createSchemaNode("number"));
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor2, JavaType typeHint) throws JsonMappingException {
            this.visitArrayFormat(visitor2, typeHint, JsonFormatTypes.NUMBER);
        }
    }

    @JacksonStdImpl
    public static class BinaryFloatArraySerializer
    extends StdSerializer<float[]>
    implements ContextualSerializer {
        private static final long serialVersionUID = 1L;
        static final BinaryFloatArraySerializer instance = new BinaryFloatArraySerializer();

        public BinaryFloatArraySerializer() {
            super(float[].class);
        }

        @Override
        public boolean isEmpty(SerializerProvider prov, float[] value2) {
            return value2.length == 0;
        }

        @Override
        public JsonSerializer<?> createContextual(SerializerProvider ctxt, BeanProperty property2) throws JsonMappingException {
            JsonFormat.Value format2 = this.findFormatOverrides(ctxt, property2, this.handledType());
            if (format2 != null) {
                switch (format2.getShape()) {
                    case ARRAY: 
                    case NATURAL: {
                        return FloatArraySerializer.instance;
                    }
                }
            }
            return this;
        }

        @Override
        public void serialize(float[] value2, JsonGenerator g2, SerializerProvider ctxt) throws IOException {
            int vectorLen = value2.length;
            byte[] b2 = new byte[vectorLen << 2];
            int out2 = 0;
            for (int i2 = 0; i2 < vectorLen; ++i2) {
                int floatBits = Float.floatToIntBits(value2[i2]);
                b2[out2++] = (byte)(floatBits >> 24);
                b2[out2++] = (byte)(floatBits >> 16);
                b2[out2++] = (byte)(floatBits >> 8);
                b2[out2++] = (byte)floatBits;
            }
            g2.writeBinary(ctxt.getConfig().getBase64Variant(), b2, 0, b2.length);
        }

        @Override
        public void serializeWithType(float[] value2, JsonGenerator g2, SerializerProvider ctxt, TypeSerializer typeSer) throws IOException {
            WritableTypeId typeIdDef = typeSer.writeTypePrefix(g2, typeSer.typeId(value2, JsonToken.VALUE_EMBEDDED_OBJECT));
            this.serialize(value2, g2, ctxt);
            typeSer.writeTypeSuffix(g2, typeIdDef);
        }

        @Override
        @Deprecated
        public JsonNode getSchema(SerializerProvider provider2, Type typeHint) {
            return this.createSchemaNode("array", true).set("items", this.createSchemaNode("number"));
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor2, JavaType typeHint) throws JsonMappingException {
            this.visitArrayFormat(visitor2, typeHint, JsonFormatTypes.NUMBER);
        }
    }

    @JacksonStdImpl
    public static class DoubleArraySerializer
    extends ArraySerializerBase<double[]> {
        private static final JavaType VALUE_TYPE = StdArraySerializers.simpleElementType(Double.TYPE);
        static final DoubleArraySerializer instance = new DoubleArraySerializer();

        public DoubleArraySerializer() {
            super(double[].class);
        }

        protected DoubleArraySerializer(DoubleArraySerializer src, BeanProperty prop, Boolean unwrapSingle) {
            super(src, prop, unwrapSingle);
        }

        @Override
        public JsonSerializer<?> _withResolved(BeanProperty prop, Boolean unwrapSingle) {
            return new DoubleArraySerializer(this, prop, unwrapSingle);
        }

        @Override
        public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
            return this;
        }

        @Override
        public JavaType getContentType() {
            return VALUE_TYPE;
        }

        @Override
        public JsonSerializer<?> getContentSerializer() {
            return null;
        }

        @Override
        public boolean isEmpty(SerializerProvider prov, double[] value2) {
            return value2.length == 0;
        }

        @Override
        public boolean hasSingleElement(double[] value2) {
            return value2.length == 1;
        }

        @Override
        public JsonSerializer<?> createContextual(SerializerProvider ctxt, BeanProperty property2) throws JsonMappingException {
            JsonFormat.Value format2 = this.findFormatOverrides(ctxt, property2, this.handledType());
            if (format2 != null && format2.getShape() == JsonFormat.Shape.BINARY) {
                return BinaryDoubleArraySerializer.instance;
            }
            return super.createContextual(ctxt, property2);
        }

        @Override
        public final void serialize(double[] value2, JsonGenerator g2, SerializerProvider provider2) throws IOException {
            int len2 = value2.length;
            if (len2 == 1 && this._shouldUnwrapSingle(provider2)) {
                this.serializeContents(value2, g2, provider2);
                return;
            }
            g2.writeArray(value2, 0, value2.length);
        }

        @Override
        public void serializeContents(double[] value2, JsonGenerator g2, SerializerProvider provider2) throws IOException {
            int len2 = value2.length;
            for (int i2 = 0; i2 < len2; ++i2) {
                g2.writeNumber(value2[i2]);
            }
        }

        @Override
        @Deprecated
        public JsonNode getSchema(SerializerProvider provider2, Type typeHint) {
            return this.createSchemaNode("array", true).set("items", this.createSchemaNode("number"));
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor2, JavaType typeHint) throws JsonMappingException {
            this.visitArrayFormat(visitor2, typeHint, JsonFormatTypes.NUMBER);
        }
    }

    @JacksonStdImpl
    public static class FloatArraySerializer
    extends TypedPrimitiveArraySerializer<float[]> {
        private static final JavaType VALUE_TYPE = StdArraySerializers.simpleElementType(Float.TYPE);
        static final FloatArraySerializer instance = new FloatArraySerializer();

        public FloatArraySerializer() {
            super(float[].class);
        }

        public FloatArraySerializer(FloatArraySerializer src, BeanProperty prop, Boolean unwrapSingle) {
            super(src, prop, unwrapSingle);
        }

        @Override
        public JsonSerializer<?> _withResolved(BeanProperty prop, Boolean unwrapSingle) {
            return new FloatArraySerializer(this, prop, unwrapSingle);
        }

        @Override
        public JavaType getContentType() {
            return VALUE_TYPE;
        }

        @Override
        public JsonSerializer<?> getContentSerializer() {
            return null;
        }

        @Override
        public boolean isEmpty(SerializerProvider prov, float[] value2) {
            return value2.length == 0;
        }

        @Override
        public boolean hasSingleElement(float[] value2) {
            return value2.length == 1;
        }

        @Override
        public JsonSerializer<?> createContextual(SerializerProvider ctxt, BeanProperty property2) throws JsonMappingException {
            JsonFormat.Value format2 = this.findFormatOverrides(ctxt, property2, this.handledType());
            if (format2 != null && format2.getShape() == JsonFormat.Shape.BINARY) {
                return BinaryFloatArraySerializer.instance;
            }
            return super.createContextual(ctxt, property2);
        }

        @Override
        public final void serialize(float[] value2, JsonGenerator g2, SerializerProvider provider2) throws IOException {
            int len2 = value2.length;
            if (len2 == 1 && this._shouldUnwrapSingle(provider2)) {
                this.serializeContents(value2, g2, provider2);
                return;
            }
            g2.writeStartArray(value2, len2);
            this.serializeContents(value2, g2, provider2);
            g2.writeEndArray();
        }

        @Override
        public void serializeContents(float[] value2, JsonGenerator g2, SerializerProvider provider2) throws IOException {
            int len2 = value2.length;
            for (int i2 = 0; i2 < len2; ++i2) {
                g2.writeNumber(value2[i2]);
            }
        }

        @Override
        @Deprecated
        public JsonNode getSchema(SerializerProvider provider2, Type typeHint) {
            return this.createSchemaNode("array", true).set("items", this.createSchemaNode("number"));
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor2, JavaType typeHint) throws JsonMappingException {
            this.visitArrayFormat(visitor2, typeHint, JsonFormatTypes.NUMBER);
        }
    }

    @JacksonStdImpl
    public static class LongArraySerializer
    extends TypedPrimitiveArraySerializer<long[]> {
        private static final JavaType VALUE_TYPE = StdArraySerializers.simpleElementType(Long.TYPE);

        public LongArraySerializer() {
            super(long[].class);
        }

        public LongArraySerializer(LongArraySerializer src, BeanProperty prop, Boolean unwrapSingle) {
            super(src, prop, unwrapSingle);
        }

        @Override
        public JsonSerializer<?> _withResolved(BeanProperty prop, Boolean unwrapSingle) {
            return new LongArraySerializer(this, prop, unwrapSingle);
        }

        @Override
        public JavaType getContentType() {
            return VALUE_TYPE;
        }

        @Override
        public JsonSerializer<?> getContentSerializer() {
            return null;
        }

        @Override
        public boolean isEmpty(SerializerProvider prov, long[] value2) {
            return value2.length == 0;
        }

        @Override
        public boolean hasSingleElement(long[] value2) {
            return value2.length == 1;
        }

        @Override
        public final void serialize(long[] value2, JsonGenerator g2, SerializerProvider provider2) throws IOException {
            int len2 = value2.length;
            if (len2 == 1 && this._shouldUnwrapSingle(provider2)) {
                this.serializeContents(value2, g2, provider2);
                return;
            }
            g2.writeArray(value2, 0, value2.length);
        }

        @Override
        public void serializeContents(long[] value2, JsonGenerator g2, SerializerProvider provider2) throws IOException {
            int len2 = value2.length;
            for (int i2 = 0; i2 < len2; ++i2) {
                g2.writeNumber(value2[i2]);
            }
        }

        @Override
        @Deprecated
        public JsonNode getSchema(SerializerProvider provider2, Type typeHint) {
            return this.createSchemaNode("array", true).set("items", this.createSchemaNode("number", true));
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor2, JavaType typeHint) throws JsonMappingException {
            this.visitArrayFormat(visitor2, typeHint, JsonFormatTypes.NUMBER);
        }
    }

    @JacksonStdImpl
    public static class IntArraySerializer
    extends ArraySerializerBase<int[]> {
        private static final JavaType VALUE_TYPE = StdArraySerializers.simpleElementType(Integer.TYPE);

        public IntArraySerializer() {
            super(int[].class);
        }

        protected IntArraySerializer(IntArraySerializer src, BeanProperty prop, Boolean unwrapSingle) {
            super(src, prop, unwrapSingle);
        }

        @Override
        public JsonSerializer<?> _withResolved(BeanProperty prop, Boolean unwrapSingle) {
            return new IntArraySerializer(this, prop, unwrapSingle);
        }

        @Override
        public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
            return this;
        }

        @Override
        public JavaType getContentType() {
            return VALUE_TYPE;
        }

        @Override
        public JsonSerializer<?> getContentSerializer() {
            return null;
        }

        @Override
        public boolean isEmpty(SerializerProvider prov, int[] value2) {
            return value2.length == 0;
        }

        @Override
        public boolean hasSingleElement(int[] value2) {
            return value2.length == 1;
        }

        @Override
        public final void serialize(int[] value2, JsonGenerator g2, SerializerProvider provider2) throws IOException {
            int len2 = value2.length;
            if (len2 == 1 && this._shouldUnwrapSingle(provider2)) {
                this.serializeContents(value2, g2, provider2);
                return;
            }
            g2.writeArray(value2, 0, value2.length);
        }

        @Override
        public void serializeContents(int[] value2, JsonGenerator g2, SerializerProvider provider2) throws IOException {
            int len2 = value2.length;
            for (int i2 = 0; i2 < len2; ++i2) {
                g2.writeNumber(value2[i2]);
            }
        }

        @Override
        @Deprecated
        public JsonNode getSchema(SerializerProvider provider2, Type typeHint) {
            return this.createSchemaNode("array", true).set("items", this.createSchemaNode("integer"));
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor2, JavaType typeHint) throws JsonMappingException {
            this.visitArrayFormat(visitor2, typeHint, JsonFormatTypes.INTEGER);
        }
    }

    @JacksonStdImpl
    public static class CharArraySerializer
    extends StdSerializer<char[]> {
        public CharArraySerializer() {
            super(char[].class);
        }

        @Override
        public boolean isEmpty(SerializerProvider prov, char[] value2) {
            return value2.length == 0;
        }

        @Override
        public void serialize(char[] value2, JsonGenerator g2, SerializerProvider provider2) throws IOException {
            if (provider2.isEnabled(SerializationFeature.WRITE_CHAR_ARRAYS_AS_JSON_ARRAYS)) {
                g2.writeStartArray(value2, value2.length);
                this._writeArrayContents(g2, value2);
                g2.writeEndArray();
            } else {
                g2.writeString(value2, 0, value2.length);
            }
        }

        @Override
        public void serializeWithType(char[] value2, JsonGenerator g2, SerializerProvider provider2, TypeSerializer typeSer) throws IOException {
            WritableTypeId typeIdDef;
            boolean asArray = provider2.isEnabled(SerializationFeature.WRITE_CHAR_ARRAYS_AS_JSON_ARRAYS);
            if (asArray) {
                typeIdDef = typeSer.writeTypePrefix(g2, typeSer.typeId(value2, JsonToken.START_ARRAY));
                this._writeArrayContents(g2, value2);
            } else {
                typeIdDef = typeSer.writeTypePrefix(g2, typeSer.typeId(value2, JsonToken.VALUE_STRING));
                g2.writeString(value2, 0, value2.length);
            }
            typeSer.writeTypeSuffix(g2, typeIdDef);
        }

        private final void _writeArrayContents(JsonGenerator g2, char[] value2) throws IOException {
            int len2 = value2.length;
            for (int i2 = 0; i2 < len2; ++i2) {
                g2.writeString(value2, i2, 1);
            }
        }

        @Override
        @Deprecated
        public JsonNode getSchema(SerializerProvider provider2, Type typeHint) {
            ObjectNode o = this.createSchemaNode("array", true);
            ObjectNode itemSchema = this.createSchemaNode("string");
            itemSchema.put("type", "string");
            return o.set("items", itemSchema);
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor2, JavaType typeHint) throws JsonMappingException {
            this.visitArrayFormat(visitor2, typeHint, JsonFormatTypes.STRING);
        }
    }

    @JacksonStdImpl
    public static class ShortArraySerializer
    extends TypedPrimitiveArraySerializer<short[]> {
        private static final JavaType VALUE_TYPE = StdArraySerializers.simpleElementType(Short.TYPE);

        public ShortArraySerializer() {
            super(short[].class);
        }

        public ShortArraySerializer(ShortArraySerializer src, BeanProperty prop, Boolean unwrapSingle) {
            super(src, prop, unwrapSingle);
        }

        @Override
        public JsonSerializer<?> _withResolved(BeanProperty prop, Boolean unwrapSingle) {
            return new ShortArraySerializer(this, prop, unwrapSingle);
        }

        @Override
        public JavaType getContentType() {
            return VALUE_TYPE;
        }

        @Override
        public JsonSerializer<?> getContentSerializer() {
            return null;
        }

        @Override
        public boolean isEmpty(SerializerProvider prov, short[] value2) {
            return value2.length == 0;
        }

        @Override
        public boolean hasSingleElement(short[] value2) {
            return value2.length == 1;
        }

        @Override
        public final void serialize(short[] value2, JsonGenerator g2, SerializerProvider provider2) throws IOException {
            int len2 = value2.length;
            if (len2 == 1 && this._shouldUnwrapSingle(provider2)) {
                this.serializeContents(value2, g2, provider2);
                return;
            }
            g2.writeStartArray(value2, len2);
            this.serializeContents(value2, g2, provider2);
            g2.writeEndArray();
        }

        @Override
        public void serializeContents(short[] value2, JsonGenerator g2, SerializerProvider provider2) throws IOException {
            int len2 = value2.length;
            for (int i2 = 0; i2 < len2; ++i2) {
                g2.writeNumber((int)value2[i2]);
            }
        }

        @Override
        @Deprecated
        public JsonNode getSchema(SerializerProvider provider2, Type typeHint) {
            ObjectNode o = this.createSchemaNode("array", true);
            return o.set("items", this.createSchemaNode("integer"));
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor2, JavaType typeHint) throws JsonMappingException {
            this.visitArrayFormat(visitor2, typeHint, JsonFormatTypes.INTEGER);
        }
    }

    @JacksonStdImpl
    public static class BooleanArraySerializer
    extends ArraySerializerBase<boolean[]> {
        private static final JavaType VALUE_TYPE = StdArraySerializers.simpleElementType(Boolean.TYPE);

        public BooleanArraySerializer() {
            super(boolean[].class);
        }

        protected BooleanArraySerializer(BooleanArraySerializer src, BeanProperty prop, Boolean unwrapSingle) {
            super(src, prop, unwrapSingle);
        }

        @Override
        public JsonSerializer<?> _withResolved(BeanProperty prop, Boolean unwrapSingle) {
            return new BooleanArraySerializer(this, prop, unwrapSingle);
        }

        @Override
        public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
            return this;
        }

        @Override
        public JavaType getContentType() {
            return VALUE_TYPE;
        }

        @Override
        public JsonSerializer<?> getContentSerializer() {
            return null;
        }

        @Override
        public boolean isEmpty(SerializerProvider prov, boolean[] value2) {
            return value2.length == 0;
        }

        @Override
        public boolean hasSingleElement(boolean[] value2) {
            return value2.length == 1;
        }

        @Override
        public final void serialize(boolean[] value2, JsonGenerator g2, SerializerProvider provider2) throws IOException {
            int len2 = value2.length;
            if (len2 == 1 && this._shouldUnwrapSingle(provider2)) {
                this.serializeContents(value2, g2, provider2);
                return;
            }
            g2.writeStartArray(value2, len2);
            this.serializeContents(value2, g2, provider2);
            g2.writeEndArray();
        }

        @Override
        public void serializeContents(boolean[] value2, JsonGenerator g2, SerializerProvider provider2) throws IOException {
            int len2 = value2.length;
            for (int i2 = 0; i2 < len2; ++i2) {
                g2.writeBoolean(value2[i2]);
            }
        }

        @Override
        @Deprecated
        public JsonNode getSchema(SerializerProvider provider2, Type typeHint) {
            ObjectNode o = this.createSchemaNode("array", true);
            o.set("items", this.createSchemaNode("boolean"));
            return o;
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor2, JavaType typeHint) throws JsonMappingException {
            this.visitArrayFormat(visitor2, typeHint, JsonFormatTypes.BOOLEAN);
        }
    }

    protected static abstract class TypedPrimitiveArraySerializer<T>
    extends ArraySerializerBase<T> {
        protected TypedPrimitiveArraySerializer(Class<T> cls) {
            super(cls);
        }

        protected TypedPrimitiveArraySerializer(TypedPrimitiveArraySerializer<T> src, BeanProperty prop, Boolean unwrapSingle) {
            super(src, prop, unwrapSingle);
        }

        @Override
        public final ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
            return this;
        }
    }
}

