/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import java.io.Serializable;

public abstract class NameTransformer {
    public static final NameTransformer NOP = new NopTransformer();

    protected NameTransformer() {
    }

    public static NameTransformer simpleTransformer(final String prefix2, final String suffix) {
        boolean hasSuffix;
        boolean hasPrefix = prefix2 != null && !prefix2.isEmpty();
        boolean bl = hasSuffix = suffix != null && !suffix.isEmpty();
        if (hasPrefix) {
            if (hasSuffix) {
                return new NameTransformer(){

                    @Override
                    public String transform(String name) {
                        return prefix2 + name + suffix;
                    }

                    @Override
                    public String reverse(String transformed2) {
                        String str;
                        if (transformed2.startsWith(prefix2) && (str = transformed2.substring(prefix2.length())).endsWith(suffix)) {
                            return str.substring(0, str.length() - suffix.length());
                        }
                        return null;
                    }

                    public String toString() {
                        return "[PreAndSuffixTransformer('" + prefix2 + "','" + suffix + "')]";
                    }
                };
            }
            return new NameTransformer(){

                @Override
                public String transform(String name) {
                    return prefix2 + name;
                }

                @Override
                public String reverse(String transformed2) {
                    if (transformed2.startsWith(prefix2)) {
                        return transformed2.substring(prefix2.length());
                    }
                    return null;
                }

                public String toString() {
                    return "[PrefixTransformer('" + prefix2 + "')]";
                }
            };
        }
        if (hasSuffix) {
            return new NameTransformer(){

                @Override
                public String transform(String name) {
                    return name + suffix;
                }

                @Override
                public String reverse(String transformed2) {
                    if (transformed2.endsWith(suffix)) {
                        return transformed2.substring(0, transformed2.length() - suffix.length());
                    }
                    return null;
                }

                public String toString() {
                    return "[SuffixTransformer('" + suffix + "')]";
                }
            };
        }
        return NOP;
    }

    public static NameTransformer chainedTransformer(NameTransformer t1, NameTransformer t2) {
        return new Chained(t1, t2);
    }

    public abstract String transform(String var1);

    public abstract String reverse(String var1);

    public static class Chained
    extends NameTransformer
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected final NameTransformer _t1;
        protected final NameTransformer _t2;

        public Chained(NameTransformer t1, NameTransformer t2) {
            this._t1 = t1;
            this._t2 = t2;
        }

        @Override
        public String transform(String name) {
            return this._t1.transform(this._t2.transform(name));
        }

        @Override
        public String reverse(String transformed2) {
            if ((transformed2 = this._t1.reverse(transformed2)) != null) {
                transformed2 = this._t2.reverse(transformed2);
            }
            return transformed2;
        }

        public String toString() {
            return "[ChainedTransformer(" + this._t1 + ", " + this._t2 + ")]";
        }
    }

    protected static final class NopTransformer
    extends NameTransformer
    implements Serializable {
        private static final long serialVersionUID = 1L;

        protected NopTransformer() {
        }

        @Override
        public String transform(String name) {
            return name;
        }

        @Override
        public String reverse(String transformed2) {
            return transformed2;
        }
    }
}

