/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

public enum NamingStrategyImpls {
    LOWER_CAMEL_CASE{

        @Override
        public String translate(String beanName) {
            return beanName;
        }
    }
    ,
    UPPER_CAMEL_CASE{

        @Override
        public String translate(String beanName) {
            char uc;
            if (beanName == null || beanName.isEmpty()) {
                return beanName;
            }
            char c2 = beanName.charAt(0);
            if (c2 == (uc = Character.toUpperCase(c2))) {
                return beanName;
            }
            StringBuilder sb = new StringBuilder(beanName);
            sb.setCharAt(0, uc);
            return sb.toString();
        }
    }
    ,
    SNAKE_CASE{

        @Override
        public String translate(String beanName) {
            if (beanName == null) {
                return beanName;
            }
            int length = beanName.length();
            StringBuilder result2 = new StringBuilder(length * 2);
            int resultLength = 0;
            boolean wasPrevTranslated = false;
            for (int i2 = 0; i2 < length; ++i2) {
                char c2 = beanName.charAt(i2);
                if (i2 <= 0 && c2 == '_') continue;
                if (Character.isUpperCase(c2)) {
                    if (!wasPrevTranslated && resultLength > 0 && result2.charAt(resultLength - 1) != '_') {
                        result2.append('_');
                        ++resultLength;
                    }
                    c2 = Character.toLowerCase(c2);
                    wasPrevTranslated = true;
                } else {
                    wasPrevTranslated = false;
                }
                result2.append(c2);
                ++resultLength;
            }
            return resultLength > 0 ? result2.toString() : beanName;
        }
    }
    ,
    UPPER_SNAKE_CASE{

        @Override
        public String translate(String beanName) {
            String output = SNAKE_CASE.translate(beanName);
            if (output == null) {
                return null;
            }
            return output.toUpperCase();
        }
    }
    ,
    LOWER_CASE{

        @Override
        public String translate(String beanName) {
            if (beanName == null || beanName.isEmpty()) {
                return beanName;
            }
            return beanName.toLowerCase();
        }
    }
    ,
    KEBAB_CASE{

        @Override
        public String translate(String beanName) {
            return 6.translateLowerCaseWithSeparator(beanName, '-');
        }
    }
    ,
    LOWER_DOT_CASE{

        @Override
        public String translate(String beanName) {
            return 7.translateLowerCaseWithSeparator(beanName, '.');
        }
    };


    public abstract String translate(String var1);

    static String translateLowerCaseWithSeparator(String beanName, char separator) {
        if (beanName == null || beanName.isEmpty()) {
            return beanName;
        }
        int length = beanName.length();
        StringBuilder result2 = new StringBuilder(length + (length >> 1));
        int upperCount = 0;
        for (int i2 = 0; i2 < length; ++i2) {
            char ch = beanName.charAt(i2);
            char lc = Character.toLowerCase(ch);
            if (lc == ch) {
                if (upperCount > 1) {
                    result2.insert(result2.length() - 1, separator);
                }
                upperCount = 0;
            } else {
                if (upperCount == 0 && i2 > 0) {
                    result2.append(separator);
                }
                ++upperCount;
            }
            result2.append(lc);
        }
        return result2.toString();
    }
}

