/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.yaml;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.format.InputAccessor;
import com.fasterxml.jackson.core.format.MatchStrength;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.dataformat.yaml.PackageVersion;
import com.fasterxml.jackson.dataformat.yaml.UTF8Reader;
import com.fasterxml.jackson.dataformat.yaml.UTF8Writer;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactoryBuilder;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.dataformat.yaml.YAMLParser;
import com.fasterxml.jackson.dataformat.yaml.util.StringQuotingChecker;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;

public class YAMLFactory
extends JsonFactory {
    private static final long serialVersionUID = 1L;
    public static final String FORMAT_NAME_YAML = "YAML";
    protected static final int DEFAULT_YAML_PARSER_FEATURE_FLAGS = YAMLParser.Feature.collectDefaults();
    protected static final int DEFAULT_YAML_GENERATOR_FEATURE_FLAGS = YAMLGenerator.Feature.collectDefaults();
    private static final byte UTF8_BOM_1 = -17;
    private static final byte UTF8_BOM_2 = -69;
    private static final byte UTF8_BOM_3 = -65;
    protected int _yamlGeneratorFeatures = DEFAULT_YAML_GENERATOR_FEATURE_FLAGS;
    protected int _yamlParserFeatures = DEFAULT_YAML_PARSER_FEATURE_FLAGS;
    protected final DumperOptions.Version _version;
    protected final StringQuotingChecker _quotingChecker;
    protected final LoaderOptions _loaderOptions;
    protected final DumperOptions _dumperOptions;

    public YAMLFactory() {
        this((ObjectCodec)null);
    }

    public YAMLFactory(ObjectCodec oc) {
        super(oc);
        this._yamlGeneratorFeatures = DEFAULT_YAML_GENERATOR_FEATURE_FLAGS;
        this._yamlParserFeatures = DEFAULT_YAML_PARSER_FEATURE_FLAGS;
        this._version = null;
        this._quotingChecker = StringQuotingChecker.Default.instance();
        this._loaderOptions = null;
        this._dumperOptions = null;
    }

    public YAMLFactory(YAMLFactory src, ObjectCodec oc) {
        super(src, oc);
        this._yamlGeneratorFeatures = src._yamlGeneratorFeatures;
        this._yamlParserFeatures = src._yamlParserFeatures;
        this._version = src._version;
        this._quotingChecker = src._quotingChecker;
        this._loaderOptions = src._loaderOptions;
        this._dumperOptions = src._dumperOptions;
    }

    protected YAMLFactory(YAMLFactoryBuilder b2) {
        super(b2, false);
        this._yamlGeneratorFeatures = b2.formatGeneratorFeaturesMask();
        this._yamlParserFeatures = b2.formatParserFeaturesMask();
        this._version = b2.yamlVersionToWrite();
        this._quotingChecker = b2.stringQuotingChecker();
        this._loaderOptions = b2.loaderOptions();
        this._dumperOptions = b2.dumperOptions();
    }

    public YAMLFactoryBuilder rebuild() {
        return new YAMLFactoryBuilder(this);
    }

    public static YAMLFactoryBuilder builder() {
        return new YAMLFactoryBuilder();
    }

    @Override
    public YAMLFactory copy() {
        this._checkInvalidCopy(YAMLFactory.class);
        return new YAMLFactory(this, null);
    }

    @Override
    protected Object readResolve() {
        return new YAMLFactory(this, this._objectCodec);
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    public boolean canUseCharArrays() {
        return false;
    }

    public Class<YAMLParser.Feature> getFormatReadFeatureType() {
        return YAMLParser.Feature.class;
    }

    public Class<YAMLGenerator.Feature> getFormatWriteFeatureType() {
        return YAMLGenerator.Feature.class;
    }

    @Override
    public String getFormatName() {
        return FORMAT_NAME_YAML;
    }

    @Override
    public MatchStrength hasFormat(InputAccessor acc) throws IOException {
        if (!acc.hasMoreBytes()) {
            return MatchStrength.INCONCLUSIVE;
        }
        byte b2 = acc.nextByte();
        if (b2 == -17) {
            if (!acc.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            if (acc.nextByte() != -69) {
                return MatchStrength.NO_MATCH;
            }
            if (!acc.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            if (acc.nextByte() != -65) {
                return MatchStrength.NO_MATCH;
            }
            if (!acc.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            b2 = acc.nextByte();
        }
        if (b2 == 45 && acc.hasMoreBytes() && acc.nextByte() == 45 && acc.hasMoreBytes() && acc.nextByte() == 45) {
            return MatchStrength.FULL_MATCH;
        }
        return MatchStrength.INCONCLUSIVE;
    }

    public final YAMLFactory configure(YAMLGenerator.Feature f2, boolean state) {
        if (state) {
            this.enable(f2);
        } else {
            this.disable(f2);
        }
        return this;
    }

    public YAMLFactory enable(YAMLGenerator.Feature f2) {
        this._yamlGeneratorFeatures |= f2.getMask();
        return this;
    }

    public YAMLFactory disable(YAMLGenerator.Feature f2) {
        this._yamlGeneratorFeatures &= ~f2.getMask();
        return this;
    }

    public final boolean isEnabled(YAMLGenerator.Feature f2) {
        return (this._yamlGeneratorFeatures & f2.getMask()) != 0;
    }

    @Override
    public int getFormatGeneratorFeatures() {
        return this._yamlGeneratorFeatures;
    }

    public final YAMLFactory configure(YAMLParser.Feature f2, boolean state) {
        if (state) {
            this.enable(f2);
        } else {
            this.disable(f2);
        }
        return this;
    }

    public YAMLFactory enable(YAMLParser.Feature f2) {
        this._yamlParserFeatures |= f2.getMask();
        return this;
    }

    public YAMLFactory disable(YAMLParser.Feature f2) {
        this._yamlParserFeatures &= ~f2.getMask();
        return this;
    }

    public final boolean isEnabled(YAMLParser.Feature f2) {
        return (this._yamlParserFeatures & f2.getMask()) != 0;
    }

    @Override
    public int getFormatParserFeatures() {
        return this._yamlParserFeatures;
    }

    @Override
    public YAMLParser createParser(String content2) throws IOException {
        return this.createParser(new StringReader(content2));
    }

    @Override
    public YAMLParser createParser(File f2) throws IOException {
        IOContext ctxt = this._createContext(this._createContentReference(f2), true);
        return this._createParser(this._decorate(new FileInputStream(f2), ctxt), ctxt);
    }

    @Override
    @Deprecated
    public YAMLParser createParser(URL url2) throws IOException {
        IOContext ctxt = this._createContext(this._createContentReference(url2), true);
        return this._createParser(this._decorate(this._optimizedStreamFromURL(url2), ctxt), ctxt);
    }

    @Override
    public YAMLParser createParser(InputStream in) throws IOException {
        IOContext ctxt = this._createContext(this._createContentReference(in), false);
        return this._createParser(this._decorate(in, ctxt), ctxt);
    }

    @Override
    public YAMLParser createParser(Reader r) throws IOException {
        IOContext ctxt = this._createContext(this._createContentReference(r), false);
        return this._createParser(this._decorate(r, ctxt), ctxt);
    }

    @Override
    public YAMLParser createParser(char[] data2) throws IOException {
        return this.createParser(data2, 0, data2.length);
    }

    @Override
    public YAMLParser createParser(char[] data2, int offset, int len2) throws IOException {
        return this.createParser(new CharArrayReader(data2, offset, len2));
    }

    @Override
    public YAMLParser createParser(byte[] data2) throws IOException {
        InputStream in;
        IOContext ctxt = this._createContext(this._createContentReference(data2), true);
        if (this._inputDecorator != null && (in = this._inputDecorator.decorate(ctxt, data2, 0, data2.length)) != null) {
            return this._createParser(in, ctxt);
        }
        return this._createParser(data2, 0, data2.length, ctxt);
    }

    @Override
    public YAMLParser createParser(byte[] data2, int offset, int len2) throws IOException {
        InputStream in;
        IOContext ctxt = this._createContext(this._createContentReference(data2, offset, len2), true);
        if (this._inputDecorator != null && (in = this._inputDecorator.decorate(ctxt, data2, offset, len2)) != null) {
            return this._createParser(in, ctxt);
        }
        return this._createParser(data2, offset, len2, ctxt);
    }

    @Override
    public YAMLGenerator createGenerator(OutputStream out2, JsonEncoding enc) throws IOException {
        IOContext ctxt = this._createContext(this._createContentReference(out2), false);
        ctxt.setEncoding(enc);
        return this._createGenerator(this._createWriter(this._decorate(out2, ctxt), enc, ctxt), ctxt);
    }

    @Override
    public YAMLGenerator createGenerator(OutputStream out2) throws IOException {
        IOContext ctxt = this._createContext(this._createContentReference(out2), false);
        return this._createGenerator(this._createWriter(this._decorate(out2, ctxt), JsonEncoding.UTF8, ctxt), ctxt);
    }

    @Override
    public YAMLGenerator createGenerator(Writer out2) throws IOException {
        IOContext ctxt = this._createContext(this._createContentReference(out2), false);
        return this._createGenerator(this._decorate(out2, ctxt), ctxt);
    }

    @Override
    public JsonGenerator createGenerator(File f2, JsonEncoding enc) throws IOException {
        FileOutputStream out2 = new FileOutputStream(f2);
        IOContext ctxt = this._createContext(this._createContentReference(f2), true);
        ctxt.setEncoding(enc);
        return this._createGenerator(this._createWriter(this._decorate(out2, ctxt), enc, ctxt), ctxt);
    }

    @Override
    protected YAMLParser _createParser(InputStream in, IOContext ctxt) throws IOException {
        return new YAMLParser(ctxt, this._parserFeatures, this._yamlParserFeatures, this._loaderOptions, this._objectCodec, this._createReader(in, null, ctxt));
    }

    @Override
    protected YAMLParser _createParser(Reader r, IOContext ctxt) throws IOException {
        return new YAMLParser(ctxt, this._parserFeatures, this._yamlParserFeatures, this._loaderOptions, this._objectCodec, r);
    }

    @Override
    protected YAMLParser _createParser(char[] data2, int offset, int len2, IOContext ctxt, boolean recyclable) throws IOException {
        return new YAMLParser(ctxt, this._parserFeatures, this._yamlParserFeatures, this._loaderOptions, this._objectCodec, (Reader)new CharArrayReader(data2, offset, len2));
    }

    @Override
    protected YAMLParser _createParser(byte[] data2, int offset, int len2, IOContext ctxt) throws IOException {
        return new YAMLParser(ctxt, this._parserFeatures, this._yamlParserFeatures, this._loaderOptions, this._objectCodec, this._createReader(data2, offset, len2, null, ctxt));
    }

    @Override
    protected YAMLGenerator _createGenerator(Writer out2, IOContext ctxt) throws IOException {
        int feats = this._yamlGeneratorFeatures;
        if (this._dumperOptions == null) {
            return new YAMLGenerator(ctxt, this._generatorFeatures, feats, this._quotingChecker, this._objectCodec, out2, this._version);
        }
        return new YAMLGenerator(ctxt, this._generatorFeatures, feats, this._quotingChecker, this._objectCodec, out2, this._dumperOptions);
    }

    @Override
    protected YAMLGenerator _createUTF8Generator(OutputStream out2, IOContext ctxt) throws IOException {
        throw new IllegalStateException();
    }

    @Override
    protected Writer _createWriter(OutputStream out2, JsonEncoding enc, IOContext ctxt) throws IOException {
        if (enc == JsonEncoding.UTF8) {
            return new UTF8Writer(out2);
        }
        return new OutputStreamWriter(out2, enc.getJavaName());
    }

    protected Reader _createReader(InputStream in, JsonEncoding enc, IOContext ctxt) throws IOException {
        if (enc == null) {
            enc = JsonEncoding.UTF8;
        }
        if (enc == JsonEncoding.UTF8) {
            boolean autoClose = ctxt.isResourceManaged() || this.isEnabled(JsonParser.Feature.AUTO_CLOSE_SOURCE);
            return new UTF8Reader(in, autoClose);
        }
        return new InputStreamReader(in, enc.getJavaName());
    }

    protected Reader _createReader(byte[] data2, int offset, int len2, JsonEncoding enc, IOContext ctxt) throws IOException {
        if (enc == null) {
            enc = JsonEncoding.UTF8;
        }
        if (enc == null || enc == JsonEncoding.UTF8) {
            return new UTF8Reader(data2, offset, len2, true);
        }
        ByteArrayInputStream in = new ByteArrayInputStream(data2, offset, len2);
        return new InputStreamReader((InputStream)in, enc.getJavaName());
    }
}

