/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.joda.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.StreamReadCapability;
import com.fasterxml.jackson.core.io.NumberInput;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.datatype.joda.cfg.FormatConfig;
import com.fasterxml.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import com.fasterxml.jackson.datatype.joda.deser.JodaDateDeserializerBase;
import java.io.IOException;
import org.joda.time.DateMidnight;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;

@Deprecated
public class DateMidnightDeserializer
extends JodaDateDeserializerBase<DateMidnight> {
    private static final long serialVersionUID = 1L;

    public DateMidnightDeserializer() {
        this(FormatConfig.DEFAULT_DATEONLY_FORMAT);
    }

    public DateMidnightDeserializer(JacksonJodaDateFormat format2) {
        super(DateMidnight.class, format2);
    }

    @Override
    public JodaDateDeserializerBase<?> withFormat(JacksonJodaDateFormat format2) {
        return new DateMidnightDeserializer(format2);
    }

    @Override
    public DateMidnight deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.isExpectedStartArrayToken()) {
            p.nextToken();
            int year2 = p.getIntValue();
            p.nextToken();
            int month = p.getIntValue();
            p.nextToken();
            int day2 = p.getIntValue();
            if (p.nextToken() != JsonToken.END_ARRAY) {
                throw ctxt.wrongTokenException(p, this.handledType(), JsonToken.END_ARRAY, "after DateMidnight ints");
            }
            DateTimeZone tz = this._format.isTimezoneExplicit() ? this._format.getTimeZone() : DateTimeZone.forTimeZone(ctxt.getTimeZone());
            return new DateMidnight(year2, month, day2, tz);
        }
        switch (p.currentTokenId()) {
            case 7: {
                return new DateMidnight(p.getLongValue());
            }
            case 6: {
                return this._fromString(p, ctxt, p.getText());
            }
        }
        throw ctxt.wrongTokenException(p, this.handledType(), JsonToken.START_ARRAY, "expected JSON Array, Number or String");
    }

    protected DateMidnight _fromString(JsonParser p, DeserializationContext ctxt, String value2) throws IOException {
        if ((value2 = value2.trim()).isEmpty()) {
            return (DateMidnight)this._fromEmptyString(p, ctxt, value2);
        }
        if (ctxt.isEnabled(StreamReadCapability.UNTYPED_SCALARS) && this._isValidTimestampString(value2)) {
            return this._fromTimestamp(ctxt, NumberInput.parseLong(value2));
        }
        LocalDate local = this._format.createParser(ctxt).parseLocalDate(value2);
        if (local == null) {
            return null;
        }
        return local.toDateMidnight();
    }

    protected DateMidnight _fromTimestamp(DeserializationContext ctxt, long ts) {
        return new DateMidnight(ts);
    }
}

