/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.joda.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.StreamReadCapability;
import com.fasterxml.jackson.core.io.NumberInput;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.datatype.joda.cfg.FormatConfig;
import com.fasterxml.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import com.fasterxml.jackson.datatype.joda.deser.JodaDateDeserializerBase;
import java.io.IOException;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;

public class LocalDateDeserializer
extends JodaDateDeserializerBase<LocalDate> {
    private static final long serialVersionUID = 1L;

    public LocalDateDeserializer() {
        this(FormatConfig.DEFAULT_LOCAL_DATEONLY_FORMAT);
    }

    public LocalDateDeserializer(JacksonJodaDateFormat format2) {
        super(LocalDate.class, format2);
    }

    @Override
    public JodaDateDeserializerBase<?> withFormat(JacksonJodaDateFormat format2) {
        return new LocalDateDeserializer(format2);
    }

    @Override
    public LocalDate deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        switch (p.currentTokenId()) {
            case 7: {
                return this._fromTimestamp(ctxt, p.getLongValue());
            }
            case 6: {
                return this._fromString(p, ctxt, p.getText());
            }
            case 1: {
                String str = ctxt.extractScalarFromObject(p, this, this.handledType());
                if (str == null) break;
                return this._fromString(p, ctxt, str);
            }
        }
        if (p.isExpectedStartArrayToken()) {
            return this._fromArray(p, ctxt);
        }
        return (LocalDate)ctxt.handleUnexpectedToken(this.handledType(), p.currentToken(), p, "expected String, Number or JSON Array", new Object[0]);
    }

    protected LocalDate _fromString(JsonParser p, DeserializationContext ctxt, String value2) throws IOException {
        if ((value2 = value2.trim()).isEmpty()) {
            return (LocalDate)this._fromEmptyString(p, ctxt, value2);
        }
        if (ctxt.isEnabled(StreamReadCapability.UNTYPED_SCALARS) && this._isValidTimestampString(value2)) {
            return this._fromTimestamp(ctxt, NumberInput.parseLong(value2));
        }
        return this._format.createParser(ctxt).parseLocalDate(value2);
    }

    protected LocalDate _fromArray(JsonParser p, DeserializationContext ctxt) throws IOException {
        int day2;
        int month;
        int year2 = p.nextIntValue(-1);
        if (year2 == -1) {
            year2 = this._parseIntPrimitive(p, ctxt);
        }
        if ((month = p.nextIntValue(-1)) == -1) {
            month = this._parseIntPrimitive(p, ctxt);
        }
        if ((day2 = p.nextIntValue(-1)) == -1) {
            day2 = this._parseIntPrimitive(p, ctxt);
        }
        if (p.nextToken() != JsonToken.END_ARRAY) {
            throw ctxt.wrongTokenException(p, this.handledType(), JsonToken.END_ARRAY, "after LocalDate ints");
        }
        return new LocalDate(year2, month, day2);
    }

    protected LocalDate _fromTimestamp(DeserializationContext ctxt, long ts) {
        DateTimeZone tz = this._format.isTimezoneExplicit() ? this._format.getTimeZone() : DateTimeZone.forTimeZone(ctxt.getTimeZone());
        return new LocalDate(ts, tz);
    }
}

