/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.joda.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.StreamReadCapability;
import com.fasterxml.jackson.core.io.NumberInput;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.datatype.joda.cfg.FormatConfig;
import com.fasterxml.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import com.fasterxml.jackson.datatype.joda.deser.JodaDateDeserializerBase;
import java.io.IOException;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;

public class LocalDateTimeDeserializer
extends JodaDateDeserializerBase<LocalDateTime> {
    private static final long serialVersionUID = 1L;

    public LocalDateTimeDeserializer() {
        this(FormatConfig.DEFAULT_LOCAL_DATETIME_PARSER);
    }

    public LocalDateTimeDeserializer(JacksonJodaDateFormat format2) {
        super(LocalDateTime.class, format2);
    }

    @Override
    public JodaDateDeserializerBase<?> withFormat(JacksonJodaDateFormat format2) {
        return new LocalDateTimeDeserializer(format2);
    }

    @Override
    public LocalDateTime deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        switch (p.currentTokenId()) {
            case 7: {
                return this._fromTimestamp(ctxt, p.getLongValue());
            }
            case 6: {
                return this._fromString(p, ctxt, p.getText());
            }
            case 1: {
                String str = ctxt.extractScalarFromObject(p, this, this.handledType());
                if (str == null) break;
                return this._fromString(p, ctxt, str);
            }
        }
        if (p.isExpectedStartArrayToken()) {
            return this._fromArray(p, ctxt);
        }
        return (LocalDateTime)ctxt.handleUnexpectedToken(this.handledType(), p.currentToken(), p, "expected String, Number or JSON Array", new Object[0]);
    }

    protected LocalDateTime _fromString(JsonParser p, DeserializationContext ctxt, String value2) throws IOException {
        if ((value2 = value2.trim()).isEmpty()) {
            return (LocalDateTime)this._fromEmptyString(p, ctxt, value2);
        }
        if (ctxt.isEnabled(StreamReadCapability.UNTYPED_SCALARS) && this._isValidTimestampString(value2)) {
            return this._fromTimestamp(ctxt, NumberInput.parseLong(value2));
        }
        return this._format.createParser(ctxt).parseLocalDateTime(value2);
    }

    protected LocalDateTime _fromArray(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken t2 = p.nextToken();
        LocalDateTime dt = null;
        if (t2.isNumeric()) {
            int year2 = p.getIntValue();
            t2 = p.nextToken();
            if (t2.isNumeric()) {
                int month = p.getIntValue();
                t2 = p.nextToken();
                if (t2.isNumeric()) {
                    int day2 = p.getIntValue();
                    t2 = p.nextToken();
                    if (t2.isNumeric()) {
                        int hour2 = p.getIntValue();
                        t2 = p.nextToken();
                        if (t2.isNumeric()) {
                            int minute2 = p.getIntValue();
                            t2 = p.nextToken();
                            if (t2.isNumeric()) {
                                int second2 = p.getIntValue();
                                t2 = p.nextToken();
                                int millisecond = 0;
                                if (t2.isNumeric()) {
                                    millisecond = p.getIntValue();
                                    t2 = p.nextToken();
                                }
                                dt = new LocalDateTime(year2, month, day2, hour2, minute2, second2, millisecond);
                            }
                        }
                    }
                }
            }
        }
        if (t2 == JsonToken.END_ARRAY) {
            return dt;
        }
        throw ctxt.wrongTokenException(p, this.handledType(), JsonToken.END_ARRAY, "after LocalDateTime ints");
    }

    protected LocalDateTime _fromTimestamp(DeserializationContext ctxt, long ts) {
        DateTimeZone tz = this._format.isTimezoneExplicit() ? this._format.getTimeZone() : DateTimeZone.forTimeZone(ctxt.getTimeZone());
        return new LocalDateTime(ts, tz);
    }
}

