/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.joda.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.datatype.joda.cfg.FormatConfig;
import com.fasterxml.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import com.fasterxml.jackson.datatype.joda.deser.JodaDateDeserializerBase;
import java.io.IOException;
import org.joda.time.YearMonth;

public class YearMonthDeserializer
extends JodaDateDeserializerBase<YearMonth> {
    private static final long serialVersionUID = 1L;

    public YearMonthDeserializer() {
        this(FormatConfig.DEFAULT_YEAR_MONTH_FORMAT);
    }

    public YearMonthDeserializer(JacksonJodaDateFormat format2) {
        super(YearMonth.class, format2);
    }

    @Override
    public JodaDateDeserializerBase<?> withFormat(JacksonJodaDateFormat format2) {
        return new YearMonthDeserializer(format2);
    }

    @Override
    public YearMonth deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        String str;
        if (p.hasToken(JsonToken.VALUE_STRING)) {
            return this._fromString(p, ctxt, p.getText());
        }
        if (p.isExpectedStartObjectToken() && (str = ctxt.extractScalarFromObject(p, this, this.handledType())) != null) {
            return this._fromString(p, ctxt, str);
        }
        return (YearMonth)this._handleNotString(p, ctxt);
    }

    protected YearMonth _fromString(JsonParser p, DeserializationContext ctxt, String value2) throws IOException {
        if ((value2 = value2.trim()).isEmpty()) {
            return (YearMonth)this._fromEmptyString(p, ctxt, value2);
        }
        return YearMonth.parse(value2, this._format.createParser(ctxt));
    }
}

