/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.joda.ser;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.datatype.joda.cfg.FormatConfig;
import com.fasterxml.jackson.datatype.joda.cfg.JacksonJodaPeriodFormat;
import com.fasterxml.jackson.datatype.joda.ser.JodaSerializerBase;
import java.io.IOException;
import java.lang.reflect.Type;
import org.joda.time.ReadablePeriod;

public class PeriodSerializer
extends JodaSerializerBase<ReadablePeriod>
implements ContextualSerializer {
    private static final long serialVersionUID = 1L;
    protected final JacksonJodaPeriodFormat _format;

    public PeriodSerializer() {
        this(FormatConfig.DEFAULT_PERIOD_FORMAT);
    }

    protected PeriodSerializer(JacksonJodaPeriodFormat format2) {
        super(ReadablePeriod.class);
        this._format = format2;
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property2) throws JsonMappingException {
        JsonFormat.Value ann;
        if (property2 != null && (ann = this.findFormatOverrides(prov, property2, this.handledType())) != null) {
            JacksonJodaPeriodFormat format2 = this._format;
            Boolean useTimestamp = ann.getShape().isNumeric() ? Boolean.TRUE : (ann.getShape() == JsonFormat.Shape.STRING ? Boolean.FALSE : (ann.getShape() == JsonFormat.Shape.ARRAY ? Boolean.TRUE : null));
            if (useTimestamp != null) {
                format2 = format2.withUseTimestamp(useTimestamp);
            }
            format2 = format2.withFormat(ann.getPattern());
            if ((format2 = format2.withLocale(ann.getLocale())) != this._format) {
                return new PeriodSerializer(format2);
            }
        }
        return this;
    }

    @Override
    public void serialize(ReadablePeriod value2, JsonGenerator gen, SerializerProvider provider2) throws IOException {
        gen.writeString(this._format.createFormatter(provider2).print(value2));
    }

    @Override
    @Deprecated
    public JsonNode getSchema(SerializerProvider provider2, Type typeHint) {
        return this.createSchemaNode("string", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor2, JavaType typeHint) throws JsonMappingException {
        JsonStringFormatVisitor v2 = visitor2.expectStringFormat(typeHint);
        if (v2 != null) {
            // empty if block
        }
    }
}

