/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsr310.deser;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.util.JacksonFeatureSet;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.fasterxml.jackson.databind.cfg.CoercionInputShape;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeFeature;
import com.fasterxml.jackson.datatype.jsr310.deser.JSR310DateTimeDeserializerBase;
import java.io.IOException;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

public class LocalDateDeserializer
extends JSR310DateTimeDeserializerBase<LocalDate> {
    private static final long serialVersionUID = 1L;
    private static final boolean DEFAULT_USE_TIME_ZONE_FOR_LENIENT_DATE_PARSING = JavaTimeFeature.USE_TIME_ZONE_FOR_LENIENT_DATE_PARSING.enabledByDefault();
    private static final DateTimeFormatter DEFAULT_FORMATTER = DateTimeFormatter.ISO_LOCAL_DATE;
    public static final LocalDateDeserializer INSTANCE = new LocalDateDeserializer();
    protected final boolean _useTimeZoneForLenientDateParsing;

    protected LocalDateDeserializer() {
        this(DEFAULT_FORMATTER);
    }

    public LocalDateDeserializer(DateTimeFormatter dtf) {
        super(LocalDate.class, dtf);
        this._useTimeZoneForLenientDateParsing = DEFAULT_USE_TIME_ZONE_FOR_LENIENT_DATE_PARSING;
    }

    public LocalDateDeserializer(LocalDateDeserializer base, DateTimeFormatter dtf) {
        super(base, dtf);
        this._useTimeZoneForLenientDateParsing = base._useTimeZoneForLenientDateParsing;
    }

    protected LocalDateDeserializer(LocalDateDeserializer base, Boolean leniency) {
        super(base, leniency);
        this._useTimeZoneForLenientDateParsing = base._useTimeZoneForLenientDateParsing;
    }

    protected LocalDateDeserializer(LocalDateDeserializer base, JsonFormat.Shape shape) {
        super(base, shape);
        this._useTimeZoneForLenientDateParsing = base._useTimeZoneForLenientDateParsing;
    }

    protected LocalDateDeserializer(LocalDateDeserializer base, JacksonFeatureSet<JavaTimeFeature> features) {
        super(LocalDate.class, base._formatter);
        this._useTimeZoneForLenientDateParsing = features.isEnabled(JavaTimeFeature.USE_TIME_ZONE_FOR_LENIENT_DATE_PARSING);
    }

    protected LocalDateDeserializer withDateFormat(DateTimeFormatter dtf) {
        return new LocalDateDeserializer(this, dtf);
    }

    @Override
    protected LocalDateDeserializer withLeniency(Boolean leniency) {
        return new LocalDateDeserializer(this, leniency);
    }

    protected LocalDateDeserializer withShape(JsonFormat.Shape shape) {
        return new LocalDateDeserializer(this, shape);
    }

    public LocalDateDeserializer withFeatures(JacksonFeatureSet<JavaTimeFeature> features) {
        if (this._useTimeZoneForLenientDateParsing == features.isEnabled(JavaTimeFeature.USE_TIME_ZONE_FOR_LENIENT_DATE_PARSING)) {
            return this;
        }
        return new LocalDateDeserializer(this, features);
    }

    @Override
    public LocalDate deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.hasToken(JsonToken.VALUE_STRING)) {
            return this._fromString(p, ctxt, p.getText());
        }
        if (p.isExpectedStartObjectToken()) {
            String str = ctxt.extractScalarFromObject(p, this, this.handledType());
            if (str != null) {
                return this._fromString(p, ctxt, str);
            }
            return (LocalDate)this._handleUnexpectedToken(ctxt, p, "Expected array or string", new Object[0]);
        }
        if (p.isExpectedStartArrayToken()) {
            JsonToken t2 = p.nextToken();
            if (t2 == JsonToken.END_ARRAY) {
                return null;
            }
            if (ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS) && (t2 == JsonToken.VALUE_STRING || t2 == JsonToken.VALUE_EMBEDDED_OBJECT)) {
                LocalDate parsed = this.deserialize(p, ctxt);
                if (p.nextToken() != JsonToken.END_ARRAY) {
                    this.handleMissingEndArrayForSingle(p, ctxt);
                }
                return parsed;
            }
            if (t2 == JsonToken.VALUE_NUMBER_INT) {
                int year2 = p.getIntValue();
                int month = p.nextIntValue(-1);
                int day2 = p.nextIntValue(-1);
                if (p.nextToken() != JsonToken.END_ARRAY) {
                    throw ctxt.wrongTokenException(p, this.handledType(), JsonToken.END_ARRAY, "Expected array to end");
                }
                return LocalDate.of(year2, month, day2);
            }
            ctxt.reportInputMismatch(this.handledType(), "Unexpected token (%s) within Array, expected VALUE_NUMBER_INT", new Object[]{t2});
        }
        if (p.hasToken(JsonToken.VALUE_EMBEDDED_OBJECT)) {
            return (LocalDate)p.getEmbeddedObject();
        }
        if (p.hasToken(JsonToken.VALUE_NUMBER_INT)) {
            CoercionAction act = ctxt.findCoercionAction(this.logicalType(), this._valueClass, CoercionInputShape.Integer);
            this._checkCoercionFail(ctxt, act, this.handledType(), p.getLongValue(), "Integer value (" + p.getLongValue() + ")");
            if (this._shape == JsonFormat.Shape.NUMBER_INT || this.isLenient()) {
                return LocalDate.ofEpochDay(p.getLongValue());
            }
            return (LocalDate)this._failForNotLenient(p, ctxt, JsonToken.VALUE_STRING);
        }
        return (LocalDate)this._handleUnexpectedToken(ctxt, p, "Expected array or string", new Object[0]);
    }

    protected LocalDate _fromString(JsonParser p, DeserializationContext ctxt, String string0) throws IOException {
        String string = string0.trim();
        if (string.length() == 0) {
            return (LocalDate)this._fromEmptyString(p, ctxt, string);
        }
        try {
            DateTimeFormatter format2 = this._formatter;
            if (format2 == DEFAULT_FORMATTER && string.length() > 10 && string.charAt(10) == 'T') {
                if (this.isLenient()) {
                    if (string.endsWith("Z")) {
                        if (this._useTimeZoneForLenientDateParsing) {
                            return Instant.parse(string).atZone(ctxt.getTimeZone().toZoneId()).toLocalDate();
                        }
                        return LocalDate.parse(string.substring(0, string.length() - 1), DateTimeFormatter.ISO_LOCAL_DATE_TIME);
                    }
                    return LocalDate.parse(string, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
                }
                JavaType t2 = this.getValueType(ctxt);
                return (LocalDate)ctxt.handleWeirdStringValue(t2.getRawClass(), string, "Should not contain time component when 'strict' mode set for property or type (enable 'lenient' handling to allow)", new Object[0]);
            }
            return LocalDate.parse(string, format2);
        }
        catch (DateTimeException e2) {
            return (LocalDate)this._handleDateTimeException(ctxt, e2, string);
        }
    }
}

