/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsr310.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.std.DelegatingDeserializer;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import java.io.IOException;
import java.time.Month;

public class OneBasedMonthDeserializer
extends DelegatingDeserializer {
    private static final long serialVersionUID = 1L;

    public OneBasedMonthDeserializer(JsonDeserializer<?> defaultDeserializer) {
        super(defaultDeserializer);
    }

    @Override
    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        switch (p.currentToken()) {
            case VALUE_NUMBER_INT: {
                return this._decodeMonth(p.getIntValue(), p);
            }
            case VALUE_STRING: {
                String monthSpec = p.getText();
                int oneBasedMonthNumber = this._decodeNumber(monthSpec);
                if (oneBasedMonthNumber < 0) break;
                return this._decodeMonth(oneBasedMonthNumber, p);
            }
        }
        return this.getDelegatee().deserialize(p, ctxt);
    }

    private int _decodeNumber(String text) {
        int numValue;
        switch (text.length()) {
            case 1: {
                char c2 = text.charAt(0);
                boolean cValid = '0' <= c2 && c2 <= '9';
                numValue = cValid ? c2 - 48 : -1;
                break;
            }
            case 2: {
                char c1 = text.charAt(0);
                char c2 = text.charAt(1);
                boolean c12valid = '0' <= c1 && c1 <= '9' && '0' <= c2 && c2 <= '9';
                numValue = c12valid ? 10 * (c1 - 48) + (c2 - 48) : -1;
                break;
            }
            default: {
                numValue = -1;
            }
        }
        return numValue;
    }

    private Month _decodeMonth(int oneBasedMonthNumber, JsonParser parser) throws InvalidFormatException {
        if (Month.JANUARY.getValue() <= oneBasedMonthNumber && oneBasedMonthNumber <= Month.DECEMBER.getValue()) {
            return Month.of(oneBasedMonthNumber);
        }
        throw new InvalidFormatException(parser, "Month number " + oneBasedMonthNumber + " not allowed for 1-based Month.", (Object)oneBasedMonthNumber, Integer.class);
    }

    @Override
    protected JsonDeserializer<?> newDelegatingInstance(JsonDeserializer<?> newDelegatee) {
        return new OneBasedMonthDeserializer(newDelegatee);
    }
}

