/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsr310.ser;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonValueFormat;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.JSR310FormattedSerializerBase;
import java.io.IOException;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;

public class LocalTimeSerializer
extends JSR310FormattedSerializerBase<LocalTime> {
    private static final long serialVersionUID = 1L;
    public static final LocalTimeSerializer INSTANCE = new LocalTimeSerializer();

    protected LocalTimeSerializer() {
        this((DateTimeFormatter)null);
    }

    public LocalTimeSerializer(DateTimeFormatter formatter) {
        super(LocalTime.class, formatter);
    }

    protected LocalTimeSerializer(LocalTimeSerializer base, Boolean useTimestamp, DateTimeFormatter formatter) {
        this(base, useTimestamp, null, formatter);
    }

    protected LocalTimeSerializer(LocalTimeSerializer base, Boolean useTimestamp, Boolean useNanoseconds, DateTimeFormatter formatter) {
        super(base, useTimestamp, useNanoseconds, formatter, null);
    }

    @Override
    protected JSR310FormattedSerializerBase<LocalTime> withFormat(Boolean useTimestamp, DateTimeFormatter dtf, JsonFormat.Shape shape) {
        return new LocalTimeSerializer(this, useTimestamp, dtf);
    }

    protected DateTimeFormatter _defaultFormatter() {
        return DateTimeFormatter.ISO_LOCAL_TIME;
    }

    @Override
    public void serialize(LocalTime value2, JsonGenerator g2, SerializerProvider provider2) throws IOException {
        if (this.useTimestamp(provider2)) {
            g2.writeStartArray();
            this._serializeAsArrayContents(value2, g2, provider2);
            g2.writeEndArray();
        } else {
            DateTimeFormatter dtf = this._formatter;
            if (dtf == null) {
                dtf = this._defaultFormatter();
            }
            g2.writeString(value2.format(dtf));
        }
    }

    @Override
    public void serializeWithType(LocalTime value2, JsonGenerator g2, SerializerProvider provider2, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g2, typeSer.typeId(value2, this.serializationShape(provider2)));
        if (typeIdDef != null && typeIdDef.valueShape == JsonToken.START_ARRAY) {
            this._serializeAsArrayContents(value2, g2, provider2);
        } else {
            DateTimeFormatter dtf = this._formatter;
            if (dtf == null) {
                dtf = this._defaultFormatter();
            }
            g2.writeString(value2.format(dtf));
        }
        typeSer.writeTypeSuffix(g2, typeIdDef);
    }

    private final void _serializeAsArrayContents(LocalTime value2, JsonGenerator g2, SerializerProvider provider2) throws IOException {
        g2.writeNumber(value2.getHour());
        g2.writeNumber(value2.getMinute());
        int secs = value2.getSecond();
        int nanos = value2.getNano();
        if (secs > 0 || nanos > 0) {
            g2.writeNumber(secs);
            if (nanos > 0) {
                if (this.useNanoseconds(provider2)) {
                    g2.writeNumber(nanos);
                } else {
                    g2.writeNumber(value2.get(ChronoField.MILLI_OF_SECOND));
                }
            }
        }
    }

    @Override
    protected JsonToken serializationShape(SerializerProvider provider2) {
        return this.useTimestamp(provider2) ? JsonToken.START_ARRAY : JsonToken.VALUE_STRING;
    }

    @Override
    protected JSR310FormattedSerializerBase<?> withFeatures(Boolean writeZoneId, Boolean writeNanoseconds) {
        return new LocalTimeSerializer(this, this._useTimestamp, writeNanoseconds, this._formatter);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor2, JavaType typeHint) throws JsonMappingException {
        if (this.useTimestamp(visitor2.getProvider())) {
            this._acceptTimestampVisitor(visitor2, typeHint);
        } else {
            JsonStringFormatVisitor v2 = visitor2.expectStringFormat(typeHint);
            if (v2 != null) {
                v2.format(JsonValueFormat.TIME);
            }
        }
    }
}

