/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.zjsonpatch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.flipkart.zjsonpatch.CompatibilityFlags;
import com.flipkart.zjsonpatch.JsonPatchApplicationException;
import com.flipkart.zjsonpatch.JsonPatchProcessor;
import com.flipkart.zjsonpatch.JsonPointer;
import com.flipkart.zjsonpatch.JsonPointerEvaluationException;
import com.flipkart.zjsonpatch.Operation;
import java.util.EnumSet;

class InPlaceApplyProcessor
implements JsonPatchProcessor {
    private JsonNode target;
    private EnumSet<CompatibilityFlags> flags;

    InPlaceApplyProcessor(JsonNode target) {
        this(target, CompatibilityFlags.defaults());
    }

    InPlaceApplyProcessor(JsonNode target, EnumSet<CompatibilityFlags> flags) {
        this.target = target;
        this.flags = flags;
    }

    public JsonNode result() {
        return this.target;
    }

    @Override
    public void move(JsonPointer fromPath, JsonPointer toPath) throws JsonPointerEvaluationException {
        JsonNode valueNode = fromPath.evaluate(this.target);
        this.remove(fromPath);
        this.set(toPath, valueNode, Operation.MOVE);
    }

    @Override
    public void copy(JsonPointer fromPath, JsonPointer toPath) throws JsonPointerEvaluationException {
        JsonNode valueNode = fromPath.evaluate(this.target);
        JsonNode valueToCopy = valueNode != null ? (JsonNode)valueNode.deepCopy() : null;
        this.set(toPath, valueToCopy, Operation.COPY);
    }

    private static String show(JsonNode value2) {
        if (value2 == null || value2.isNull()) {
            return "null";
        }
        if (value2.isArray()) {
            return "array";
        }
        if (value2.isObject()) {
            return "object";
        }
        return "value " + value2.toString();
    }

    @Override
    public void test(JsonPointer path2, JsonNode value2) throws JsonPointerEvaluationException {
        JsonNode valueNode = path2.evaluate(this.target);
        if (!valueNode.equals(value2)) {
            throw new JsonPatchApplicationException("Expected " + InPlaceApplyProcessor.show(value2) + " but found " + InPlaceApplyProcessor.show(valueNode), Operation.TEST, path2);
        }
    }

    @Override
    public void add(JsonPointer path2, JsonNode value2) throws JsonPointerEvaluationException {
        this.set(path2, value2, Operation.ADD);
    }

    @Override
    public void replace(JsonPointer path2, JsonNode value2) throws JsonPointerEvaluationException {
        if (path2.isRoot()) {
            this.target = value2;
            return;
        }
        JsonNode parentNode = path2.getParent().evaluate(this.target);
        JsonPointer.RefToken token2 = path2.last();
        if (parentNode.isObject()) {
            if (!this.flags.contains((Object)CompatibilityFlags.ALLOW_MISSING_TARGET_OBJECT_ON_REPLACE) && !parentNode.has(token2.getField())) {
                throw new JsonPatchApplicationException("Missing field \"" + token2.getField() + "\"", Operation.REPLACE, path2.getParent());
            }
            ((ObjectNode)parentNode).replace(token2.getField(), value2);
        } else if (parentNode.isArray()) {
            if (token2.getIndex() >= parentNode.size()) {
                throw new JsonPatchApplicationException("Array index " + token2.getIndex() + " out of bounds", Operation.REPLACE, path2.getParent());
            }
            ((ArrayNode)parentNode).set(token2.getIndex(), value2);
        } else {
            throw new JsonPatchApplicationException("Can't reference past scalar value", Operation.REPLACE, path2.getParent());
        }
    }

    @Override
    public void remove(JsonPointer path2) throws JsonPointerEvaluationException {
        if (path2.isRoot()) {
            throw new JsonPatchApplicationException("Cannot remove document root", Operation.REMOVE, path2);
        }
        JsonNode parentNode = path2.getParent().evaluate(this.target);
        JsonPointer.RefToken token2 = path2.last();
        if (parentNode.isObject()) {
            if (this.flags.contains((Object)CompatibilityFlags.FORBID_REMOVE_MISSING_OBJECT) && !parentNode.has(token2.getField())) {
                throw new JsonPatchApplicationException("Missing field " + token2.getField(), Operation.REMOVE, path2.getParent());
            }
            ((ObjectNode)parentNode).remove(token2.getField());
        } else if (parentNode.isArray()) {
            if (!this.flags.contains((Object)CompatibilityFlags.REMOVE_NONE_EXISTING_ARRAY_ELEMENT) && token2.getIndex() >= parentNode.size()) {
                throw new JsonPatchApplicationException("Array index " + token2.getIndex() + " out of bounds", Operation.REMOVE, path2.getParent());
            }
            ((ArrayNode)parentNode).remove(token2.getIndex());
        } else {
            throw new JsonPatchApplicationException("Cannot reference past scalar value", Operation.REMOVE, path2.getParent());
        }
    }

    private void set(JsonPointer path2, JsonNode value2, Operation forOp) throws JsonPointerEvaluationException {
        if (path2.isRoot()) {
            this.target = value2;
        } else {
            JsonNode parentNode = path2.getParent().evaluate(this.target);
            if (!parentNode.isContainerNode()) {
                throw new JsonPatchApplicationException("Cannot reference past scalar value", forOp, path2.getParent());
            }
            if (parentNode.isArray()) {
                this.addToArray(path2, value2, parentNode);
            } else {
                this.addToObject(path2, parentNode, value2);
            }
        }
    }

    private void addToObject(JsonPointer path2, JsonNode node, JsonNode value2) {
        ObjectNode target = (ObjectNode)node;
        String key2 = path2.last().getField();
        target.set(key2, value2);
    }

    private void addToArray(JsonPointer path2, JsonNode value2, JsonNode parentNode) {
        ArrayNode target = (ArrayNode)parentNode;
        int idx = path2.last().getIndex();
        if (idx == Integer.MIN_VALUE) {
            target.add(value2);
        } else {
            if (idx > target.size()) {
                throw new JsonPatchApplicationException("Array index " + idx + " out of bounds", Operation.ADD, path2.getParent());
            }
            target.insert(idx, value2);
        }
    }
}

