/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.zjsonpatch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.flipkart.zjsonpatch.Diff;
import com.flipkart.zjsonpatch.DiffFlags;
import com.flipkart.zjsonpatch.InternalUtils;
import com.flipkart.zjsonpatch.JsonPointer;
import com.flipkart.zjsonpatch.NodeType;
import com.flipkart.zjsonpatch.Operation;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.ListUtils;

public final class JsonDiff {
    private final List<Diff> diffs = new ArrayList<Diff>();
    private final EnumSet<DiffFlags> flags;

    private JsonDiff(EnumSet<DiffFlags> flags) {
        this.flags = flags.clone();
    }

    public static JsonNode asJson(JsonNode source2, JsonNode target) {
        return JsonDiff.asJson(source2, target, DiffFlags.defaults());
    }

    public static JsonNode asJson(JsonNode source2, JsonNode target, EnumSet<DiffFlags> flags) {
        JsonDiff diff = new JsonDiff(flags);
        if (source2 == null && target != null) {
            diff.diffs.add(Diff.generateDiff(Operation.ADD, JsonPointer.ROOT, target));
        }
        if (source2 != null && target == null) {
            diff.diffs.add(Diff.generateDiff(Operation.REMOVE, JsonPointer.ROOT, source2));
        }
        if (source2 != null && target != null) {
            diff.generateDiffs(JsonPointer.ROOT, source2, target);
            if (!flags.contains((Object)DiffFlags.OMIT_MOVE_OPERATION)) {
                diff.introduceMoveOperation();
            }
            if (!flags.contains((Object)DiffFlags.OMIT_COPY_OPERATION)) {
                diff.introduceCopyOperation(source2, target);
            }
            if (flags.contains((Object)DiffFlags.ADD_EXPLICIT_REMOVE_ADD_ON_REPLACE)) {
                diff.introduceExplicitRemoveAndAddOperation();
            }
        }
        return diff.getJsonNodes();
    }

    private static JsonPointer getMatchingValuePath(Map<JsonNode, JsonPointer> unchangedValues, JsonNode value2) {
        return unchangedValues.get(value2);
    }

    private void introduceCopyOperation(JsonNode source2, JsonNode target) {
        Map<JsonNode, JsonPointer> unchangedValues = JsonDiff.getUnchangedPart(source2, target);
        for (int i2 = 0; i2 < this.diffs.size(); ++i2) {
            JsonPointer matchingValuePath;
            Diff diff = this.diffs.get(i2);
            if (Operation.ADD != diff.getOperation() || (matchingValuePath = JsonDiff.getMatchingValuePath(unchangedValues, diff.getValue())) == null || !JsonDiff.isAllowed(matchingValuePath, diff.getPath())) continue;
            if (this.flags.contains((Object)DiffFlags.EMIT_TEST_OPERATIONS)) {
                this.diffs.add(i2, new Diff(Operation.TEST, matchingValuePath, diff.getValue()));
                ++i2;
            }
            this.diffs.set(i2, new Diff(Operation.COPY, matchingValuePath, diff.getPath()));
        }
    }

    private static boolean isNumber(String str) {
        int size2 = str.length();
        for (int i2 = 0; i2 < size2; ++i2) {
            if (Character.isDigit(str.charAt(i2))) continue;
            return false;
        }
        return size2 > 0;
    }

    private static boolean isAllowed(JsonPointer source2, JsonPointer destination) {
        boolean isSame = source2.equals(destination);
        int i2 = 0;
        for (int j2 = 0; i2 < source2.size() && j2 < destination.size(); ++i2, ++j2) {
            JsonPointer.RefToken srcValue = source2.get(i2);
            JsonPointer.RefToken dstValue = destination.get(j2);
            String srcStr = srcValue.toString();
            String dstStr = dstValue.toString();
            if (!JsonDiff.isNumber(srcStr) || !JsonDiff.isNumber(dstStr) || srcStr.compareTo(dstStr) <= 0) continue;
            return false;
        }
        return !isSame;
    }

    private static Map<JsonNode, JsonPointer> getUnchangedPart(JsonNode source2, JsonNode target) {
        HashMap<JsonNode, JsonPointer> unchangedValues = new HashMap<JsonNode, JsonPointer>();
        JsonDiff.computeUnchangedValues(unchangedValues, JsonPointer.ROOT, source2, target);
        return unchangedValues;
    }

    private static void computeUnchangedValues(Map<JsonNode, JsonPointer> unchangedValues, JsonPointer path2, JsonNode source2, JsonNode target) {
        NodeType secondType;
        if (source2.equals(target)) {
            if (!unchangedValues.containsKey(target)) {
                unchangedValues.put(target, path2);
            }
            return;
        }
        NodeType firstType = NodeType.getNodeType(source2);
        if (firstType == (secondType = NodeType.getNodeType(target))) {
            switch (firstType) {
                case OBJECT: {
                    JsonDiff.computeObject(unchangedValues, path2, source2, target);
                    break;
                }
                case ARRAY: {
                    JsonDiff.computeArray(unchangedValues, path2, source2, target);
                    break;
                }
            }
        }
    }

    private static void computeArray(Map<JsonNode, JsonPointer> unchangedValues, JsonPointer path2, JsonNode source2, JsonNode target) {
        int size2 = Math.min(source2.size(), target.size());
        for (int i2 = 0; i2 < size2; ++i2) {
            JsonPointer currPath = path2.append(i2);
            JsonDiff.computeUnchangedValues(unchangedValues, currPath, source2.get(i2), target.get(i2));
        }
    }

    private static void computeObject(Map<JsonNode, JsonPointer> unchangedValues, JsonPointer path2, JsonNode source2, JsonNode target) {
        Iterator<String> firstFields = source2.fieldNames();
        while (firstFields.hasNext()) {
            String name = firstFields.next();
            if (!target.has(name)) continue;
            JsonPointer currPath = path2.append(name);
            JsonDiff.computeUnchangedValues(unchangedValues, currPath, source2.get(name), target.get(name));
        }
    }

    private void introduceMoveOperation() {
        block0: for (int i2 = 0; i2 < this.diffs.size(); ++i2) {
            Diff diff1 = this.diffs.get(i2);
            if (Operation.REMOVE != diff1.getOperation() && Operation.ADD != diff1.getOperation()) continue;
            for (int j2 = i2 + 1; j2 < this.diffs.size(); ++j2) {
                JsonPointer relativePath;
                Diff diff2 = this.diffs.get(j2);
                if (!diff1.getValue().equals(diff2.getValue())) continue;
                Diff moveDiff = null;
                if (Operation.REMOVE == diff1.getOperation() && Operation.ADD == diff2.getOperation()) {
                    relativePath = JsonDiff.computeRelativePath(diff2.getPath(), i2 + 1, j2 - 1, this.diffs);
                    moveDiff = new Diff(Operation.MOVE, diff1.getPath(), relativePath);
                } else if (Operation.ADD == diff1.getOperation() && Operation.REMOVE == diff2.getOperation()) {
                    relativePath = JsonDiff.computeRelativePath(diff2.getPath(), i2, j2 - 1, this.diffs);
                    moveDiff = new Diff(Operation.MOVE, relativePath, diff1.getPath());
                }
                if (moveDiff == null) continue;
                this.diffs.remove(j2);
                this.diffs.set(i2, moveDiff);
                continue block0;
            }
        }
    }

    private void introduceExplicitRemoveAndAddOperation() {
        ArrayList<Diff> updatedDiffs = new ArrayList<Diff>();
        for (Diff diff : this.diffs) {
            if (!diff.getOperation().equals((Object)Operation.REPLACE) || diff.getSrcValue() == null) {
                updatedDiffs.add(diff);
                continue;
            }
            updatedDiffs.add(new Diff(Operation.REMOVE, diff.getPath(), diff.getSrcValue()));
            updatedDiffs.add(new Diff(Operation.ADD, diff.getPath(), diff.getValue()));
        }
        this.diffs.clear();
        this.diffs.addAll(updatedDiffs);
    }

    private static JsonPointer computeRelativePath(JsonPointer path2, int startIdx, int endIdx, List<Diff> diffs) {
        int i2;
        ArrayList<Integer> counters = new ArrayList<Integer>(path2.size());
        for (i2 = 0; i2 < path2.size(); ++i2) {
            counters.add(0);
        }
        for (i2 = startIdx; i2 <= endIdx; ++i2) {
            Diff diff = diffs.get(i2);
            if (Operation.ADD != diff.getOperation() && Operation.REMOVE != diff.getOperation()) continue;
            JsonDiff.updatePath(path2, diff, counters);
        }
        return JsonDiff.updatePathWithCounters(counters, path2);
    }

    private static JsonPointer updatePathWithCounters(List<Integer> counters, JsonPointer path2) {
        List<JsonPointer.RefToken> tokens = path2.decompose();
        for (int i2 = 0; i2 < counters.size(); ++i2) {
            int value2 = counters.get(i2);
            if (value2 == 0) continue;
            int currValue = tokens.get(i2).getIndex();
            tokens.set(i2, new JsonPointer.RefToken(Integer.toString(currValue + value2)));
        }
        return new JsonPointer(tokens);
    }

    private static void updatePath(JsonPointer path2, Diff pseudo, List<Integer> counters) {
        if (pseudo.getPath().size() <= path2.size()) {
            int idx = -1;
            int i2 = 0;
            while (i2 < pseudo.getPath().size() - 1 && pseudo.getPath().get(i2).equals(path2.get(i2))) {
                idx = i2++;
            }
            if (idx == pseudo.getPath().size() - 2 && pseudo.getPath().get(pseudo.getPath().size() - 1).isArrayIndex()) {
                JsonDiff.updateCounters(pseudo, pseudo.getPath().size() - 1, counters);
            }
        }
    }

    private static void updateCounters(Diff pseudo, int idx, List<Integer> counters) {
        if (Operation.ADD == pseudo.getOperation()) {
            counters.set(idx, counters.get(idx) - 1);
        } else if (Operation.REMOVE == pseudo.getOperation()) {
            counters.set(idx, counters.get(idx) + 1);
        }
    }

    private ArrayNode getJsonNodes() {
        JsonNodeFactory FACTORY = JsonNodeFactory.instance;
        ArrayNode patch2 = FACTORY.arrayNode();
        for (Diff diff : this.diffs) {
            ObjectNode jsonNode = JsonDiff.getJsonNode(FACTORY, diff, this.flags);
            patch2.add(jsonNode);
        }
        return patch2;
    }

    private static ObjectNode getJsonNode(JsonNodeFactory FACTORY, Diff diff, EnumSet<DiffFlags> flags) {
        ObjectNode jsonNode = FACTORY.objectNode();
        jsonNode.put("op", diff.getOperation().rfcName());
        switch (diff.getOperation()) {
            case MOVE: 
            case COPY: {
                jsonNode.put("from", diff.getPath().toString());
                jsonNode.put("path", diff.getToPath().toString());
                break;
            }
            case REMOVE: {
                jsonNode.put("path", diff.getPath().toString());
                if (flags.contains((Object)DiffFlags.OMIT_VALUE_ON_REMOVE)) break;
                jsonNode.set("value", diff.getValue());
                break;
            }
            case REPLACE: {
                if (flags.contains((Object)DiffFlags.ADD_ORIGINAL_VALUE_ON_REPLACE)) {
                    jsonNode.set("fromValue", diff.getSrcValue());
                }
            }
            case ADD: 
            case TEST: {
                jsonNode.put("path", diff.getPath().toString());
                jsonNode.set("value", diff.getValue());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown operation specified:" + (Object)((Object)diff.getOperation()));
            }
        }
        return jsonNode;
    }

    private void generateDiffs(JsonPointer path2, JsonNode source2, JsonNode target) {
        if (!source2.equals(target)) {
            NodeType sourceType = NodeType.getNodeType(source2);
            NodeType targetType = NodeType.getNodeType(target);
            if (sourceType == NodeType.ARRAY && targetType == NodeType.ARRAY) {
                this.compareArray(path2, source2, target);
            } else if (sourceType == NodeType.OBJECT && targetType == NodeType.OBJECT) {
                this.compareObjects(path2, source2, target);
            } else {
                if (this.flags.contains((Object)DiffFlags.EMIT_TEST_OPERATIONS)) {
                    this.diffs.add(new Diff(Operation.TEST, path2, source2));
                }
                this.diffs.add(Diff.generateDiff(Operation.REPLACE, path2, source2, target));
            }
        }
    }

    private void compareArray(JsonPointer path2, JsonNode source2, JsonNode target) {
        List<JsonNode> lcs = JsonDiff.getLCS(source2, target);
        int srcIdx = 0;
        int targetIdx = 0;
        int lcsIdx = 0;
        int srcSize = source2.size();
        int targetSize = target.size();
        int lcsSize = lcs.size();
        int pos = 0;
        while (lcsIdx < lcsSize) {
            JsonPointer currPath;
            JsonNode lcsNode = lcs.get(lcsIdx);
            JsonNode srcNode = source2.get(srcIdx);
            JsonNode targetNode = target.get(targetIdx);
            if (lcsNode.equals(srcNode) && lcsNode.equals(targetNode)) {
                ++srcIdx;
                ++targetIdx;
                ++lcsIdx;
                ++pos;
                continue;
            }
            if (lcsNode.equals(srcNode)) {
                currPath = path2.append(pos);
                this.diffs.add(Diff.generateDiff(Operation.ADD, currPath, targetNode));
                ++pos;
                ++targetIdx;
                continue;
            }
            if (lcsNode.equals(targetNode)) {
                currPath = path2.append(pos);
                if (this.flags.contains((Object)DiffFlags.EMIT_TEST_OPERATIONS)) {
                    this.diffs.add(new Diff(Operation.TEST, currPath, srcNode));
                }
                this.diffs.add(Diff.generateDiff(Operation.REMOVE, currPath, srcNode));
                ++srcIdx;
                continue;
            }
            currPath = path2.append(pos);
            this.generateDiffs(currPath, srcNode, targetNode);
            ++srcIdx;
            ++targetIdx;
            ++pos;
        }
        while (srcIdx < srcSize && targetIdx < targetSize) {
            JsonNode srcNode = source2.get(srcIdx);
            JsonNode targetNode = target.get(targetIdx);
            JsonPointer currPath = path2.append(pos);
            this.generateDiffs(currPath, srcNode, targetNode);
            ++srcIdx;
            ++targetIdx;
            ++pos;
        }
        pos = this.addRemaining(path2, target, pos, targetIdx, targetSize);
        this.removeRemaining(path2, pos, srcIdx, srcSize, source2);
    }

    private void removeRemaining(JsonPointer path2, int pos, int srcIdx, int srcSize, JsonNode source2) {
        while (srcIdx < srcSize) {
            JsonPointer currPath = path2.append(pos);
            if (this.flags.contains((Object)DiffFlags.EMIT_TEST_OPERATIONS)) {
                this.diffs.add(new Diff(Operation.TEST, currPath, source2.get(srcIdx)));
            }
            this.diffs.add(Diff.generateDiff(Operation.REMOVE, currPath, source2.get(srcIdx)));
            ++srcIdx;
        }
    }

    private int addRemaining(JsonPointer path2, JsonNode target, int pos, int targetIdx, int targetSize) {
        while (targetIdx < targetSize) {
            JsonNode jsonNode = target.get(targetIdx);
            JsonPointer currPath = path2.append(pos);
            this.diffs.add(Diff.generateDiff(Operation.ADD, currPath, jsonNode.deepCopy()));
            ++pos;
            ++targetIdx;
        }
        return pos;
    }

    private void compareObjects(JsonPointer path2, JsonNode source2, JsonNode target) {
        Iterator<String> keysFromSrc = source2.fieldNames();
        while (keysFromSrc.hasNext()) {
            JsonPointer currPath;
            String key2 = keysFromSrc.next();
            if (!target.has(key2)) {
                currPath = path2.append(key2);
                if (this.flags.contains((Object)DiffFlags.EMIT_TEST_OPERATIONS)) {
                    this.diffs.add(new Diff(Operation.TEST, currPath, source2.get(key2)));
                }
                this.diffs.add(Diff.generateDiff(Operation.REMOVE, currPath, source2.get(key2)));
                continue;
            }
            currPath = path2.append(key2);
            this.generateDiffs(currPath, source2.get(key2), target.get(key2));
        }
        Iterator<String> keysFromTarget = target.fieldNames();
        while (keysFromTarget.hasNext()) {
            String key3 = keysFromTarget.next();
            if (source2.has(key3)) continue;
            JsonPointer currPath = path2.append(key3);
            this.diffs.add(Diff.generateDiff(Operation.ADD, currPath, target.get(key3)));
        }
    }

    private static List<JsonNode> getLCS(JsonNode first2, JsonNode second2) {
        return ListUtils.longestCommonSubsequence(InternalUtils.toList((ArrayNode)first2), InternalUtils.toList((ArrayNode)second2));
    }
}

