/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.zjsonpatch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.flipkart.zjsonpatch.CompatibilityFlags;
import com.flipkart.zjsonpatch.CopyingApplyProcessor;
import com.flipkart.zjsonpatch.InPlaceApplyProcessor;
import com.flipkart.zjsonpatch.InvalidJsonPatchException;
import com.flipkart.zjsonpatch.JsonPatchApplicationException;
import com.flipkart.zjsonpatch.JsonPatchProcessor;
import com.flipkart.zjsonpatch.JsonPointer;
import com.flipkart.zjsonpatch.JsonPointerEvaluationException;
import com.flipkart.zjsonpatch.NoopProcessor;
import com.flipkart.zjsonpatch.Operation;
import java.util.EnumSet;

public final class JsonPatch {
    private JsonPatch() {
    }

    private static JsonNode getPatchStringAttr(JsonNode jsonNode, String attr) {
        JsonNode child = JsonPatch.getPatchAttr(jsonNode, attr);
        if (!child.isTextual()) {
            throw new InvalidJsonPatchException("Invalid JSON Patch payload (non-text '" + attr + "' field)");
        }
        return child;
    }

    private static JsonNode getPatchAttr(JsonNode jsonNode, String attr) {
        JsonNode child = jsonNode.get(attr);
        if (child == null) {
            throw new InvalidJsonPatchException("Invalid JSON Patch payload (missing '" + attr + "' field)");
        }
        return child;
    }

    private static JsonNode getPatchAttrWithDefault(JsonNode jsonNode, String attr, JsonNode defaultValue) {
        JsonNode child = jsonNode.get(attr);
        if (child == null) {
            return defaultValue;
        }
        return child;
    }

    private static void process(JsonNode patch2, JsonPatchProcessor processor, EnumSet<CompatibilityFlags> flags) throws InvalidJsonPatchException {
        if (!patch2.isArray()) {
            throw new InvalidJsonPatchException("Invalid JSON Patch payload (not an array)");
        }
        for (JsonNode jsonNode : patch2) {
            if (!jsonNode.isObject()) {
                throw new InvalidJsonPatchException("Invalid JSON Patch payload (not an object)");
            }
            Operation operation = Operation.fromRfcName(JsonPatch.getPatchStringAttr(jsonNode, "op").textValue());
            JsonPointer path2 = JsonPointer.parse(JsonPatch.getPatchStringAttr(jsonNode, "path").textValue());
            try {
                switch (operation) {
                    case REMOVE: {
                        processor.remove(path2);
                        break;
                    }
                    case ADD: {
                        JsonNode value2 = !flags.contains((Object)CompatibilityFlags.MISSING_VALUES_AS_NULLS) ? JsonPatch.getPatchAttr(jsonNode, "value") : JsonPatch.getPatchAttrWithDefault(jsonNode, "value", NullNode.getInstance());
                        processor.add(path2, (JsonNode)value2.deepCopy());
                        break;
                    }
                    case REPLACE: {
                        JsonNode value2 = !flags.contains((Object)CompatibilityFlags.MISSING_VALUES_AS_NULLS) ? JsonPatch.getPatchAttr(jsonNode, "value") : JsonPatch.getPatchAttrWithDefault(jsonNode, "value", NullNode.getInstance());
                        processor.replace(path2, (JsonNode)value2.deepCopy());
                        break;
                    }
                    case MOVE: {
                        JsonPointer fromPath = JsonPointer.parse(JsonPatch.getPatchStringAttr(jsonNode, "from").textValue());
                        processor.move(fromPath, path2);
                        break;
                    }
                    case COPY: {
                        JsonPointer fromPath = JsonPointer.parse(JsonPatch.getPatchStringAttr(jsonNode, "from").textValue());
                        processor.copy(fromPath, path2);
                        break;
                    }
                    case TEST: {
                        JsonNode value2 = !flags.contains((Object)CompatibilityFlags.MISSING_VALUES_AS_NULLS) ? JsonPatch.getPatchAttr(jsonNode, "value") : JsonPatch.getPatchAttrWithDefault(jsonNode, "value", NullNode.getInstance());
                        processor.test(path2, (JsonNode)value2.deepCopy());
                        break;
                    }
                }
            }
            catch (JsonPointerEvaluationException e2) {
                throw new JsonPatchApplicationException(e2.getMessage(), operation, e2.getPath());
            }
        }
    }

    public static void validate(JsonNode patch2, EnumSet<CompatibilityFlags> flags) throws InvalidJsonPatchException {
        JsonPatch.process(patch2, NoopProcessor.INSTANCE, flags);
    }

    public static void validate(JsonNode patch2) throws InvalidJsonPatchException {
        JsonPatch.validate(patch2, CompatibilityFlags.defaults());
    }

    public static JsonNode apply(JsonNode patch2, JsonNode source2, EnumSet<CompatibilityFlags> flags) throws JsonPatchApplicationException {
        CopyingApplyProcessor processor = new CopyingApplyProcessor(source2, flags);
        JsonPatch.process(patch2, processor, flags);
        return processor.result();
    }

    public static JsonNode apply(JsonNode patch2, JsonNode source2) throws JsonPatchApplicationException {
        return JsonPatch.apply(patch2, source2, CompatibilityFlags.defaults());
    }

    public static void applyInPlace(JsonNode patch2, JsonNode source2) {
        JsonPatch.applyInPlace(patch2, source2, CompatibilityFlags.defaults());
    }

    public static void applyInPlace(JsonNode patch2, JsonNode source2, EnumSet<CompatibilityFlags> flags) {
        InPlaceApplyProcessor processor = new InPlaceApplyProcessor(source2, flags);
        JsonPatch.process(patch2, processor, flags);
    }
}

