/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jackson;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.io.IOException;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class JacksonUtils {
    private static final JsonNodeFactory FACTORY = JsonNodeFactory.instance;
    private static final ObjectReader READER;
    private static final ObjectWriter WRITER;

    private JacksonUtils() {
    }

    public static ObjectReader getReader() {
        return READER;
    }

    public static JsonNodeFactory nodeFactory() {
        return FACTORY;
    }

    public static Map<String, JsonNode> asMap(JsonNode node) {
        HashMap<String, JsonNode> ret = new HashMap<String, JsonNode>();
        if (!node.isObject()) {
            return ret;
        }
        Iterator<Map.Entry<String, JsonNode>> iterator2 = node.fields();
        while (iterator2.hasNext()) {
            Map.Entry<String, JsonNode> entry = iterator2.next();
            ret.put(entry.getKey(), entry.getValue());
        }
        return ret;
    }

    public static String prettyPrint(JsonNode node) {
        StringWriter writer = new StringWriter();
        try {
            WRITER.writeValue(writer, (Object)node);
            writer.flush();
        }
        catch (JsonGenerationException e2) {
            throw new RuntimeException("How did I get there??", e2);
        }
        catch (JsonMappingException e3) {
            throw new RuntimeException("How did I get there??", e3);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.toString();
    }

    public static ObjectMapper newMapper() {
        return new ObjectMapper().setNodeFactory(FACTORY).enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS).enable(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN).enable(SerializationFeature.INDENT_OUTPUT);
    }

    static {
        ObjectMapper mapper = JacksonUtils.newMapper();
        READER = mapper.reader();
        WRITER = mapper.writer();
    }
}

