/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jackson;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonNodeReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public final class JsonLoader {
    private static final Pattern INITIAL_SLASH = Pattern.compile("^/+");
    private static final JsonNodeReader READER = new JsonNodeReader();

    private JsonLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonNode fromResource(@Nonnull String resource2) throws IOException {
        JsonNode ret;
        if (resource2 == null) {
            throw new NullPointerException();
        }
        if (!resource2.startsWith("/")) {
            throw new IllegalArgumentException("resource path does not start with a '/'");
        }
        URL url2 = JsonLoader.class.getResource(resource2);
        if (url2 == null) {
            ClassLoader classLoader;
            if (Thread.currentThread().getContextClassLoader() != null) {
                classLoader = Thread.currentThread().getContextClassLoader();
            } else if (JsonLoader.class.getClassLoader() != null) {
                classLoader = JsonLoader.class.getClassLoader();
            } else {
                throw new NullPointerException();
            }
            String s2 = INITIAL_SLASH.matcher(resource2).replaceFirst("");
            url2 = classLoader.getResource(s2);
        }
        if (url2 == null) {
            throw new IOException("resource " + resource2 + " not found");
        }
        try (InputStream in = null;){
            in = url2.openStream();
            ret = READER.fromInputStream(in);
        }
        return ret;
    }

    public static JsonNode fromURL(URL url2) throws IOException {
        return READER.fromInputStream(url2.openStream());
    }

    public static JsonNode fromPath(String path2) throws IOException {
        JsonNode ret;
        try (FileInputStream in = null;){
            in = new FileInputStream(path2);
            ret = READER.fromInputStream(in);
        }
        return ret;
    }

    public static JsonNode fromFile(File file2) throws IOException {
        JsonNode ret;
        try (FileInputStream in = null;){
            in = new FileInputStream(file2);
            ret = READER.fromInputStream(in);
        }
        return ret;
    }

    public static JsonNode fromReader(Reader reader2) throws IOException {
        return READER.fromReader(reader2);
    }

    public static JsonNode fromString(String json2) throws IOException {
        return JsonLoader.fromReader(new StringReader(json2));
    }
}

