/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jackson;

import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

public enum NodeType {
    ARRAY("array"),
    BOOLEAN("boolean"),
    INTEGER("integer"),
    NULL("null"),
    NUMBER("number"),
    OBJECT("object"),
    STRING("string");

    private final String name;
    private static final Map<String, NodeType> NAME_MAP;
    private static final Map<JsonToken, NodeType> TOKEN_MAP;

    private NodeType(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public static NodeType fromName(String name) {
        return NAME_MAP.get(name);
    }

    public static NodeType getNodeType(JsonNode node) {
        JsonToken token2 = node.asToken();
        NodeType ret = TOKEN_MAP.get((Object)token2);
        if (ret == null) {
            throw new NullPointerException("unhandled token type " + (Object)((Object)token2));
        }
        return ret;
    }

    static {
        TOKEN_MAP = new EnumMap<JsonToken, NodeType>(JsonToken.class);
        TOKEN_MAP.put(JsonToken.START_ARRAY, ARRAY);
        TOKEN_MAP.put(JsonToken.VALUE_TRUE, BOOLEAN);
        TOKEN_MAP.put(JsonToken.VALUE_FALSE, BOOLEAN);
        TOKEN_MAP.put(JsonToken.VALUE_NUMBER_INT, INTEGER);
        TOKEN_MAP.put(JsonToken.VALUE_NUMBER_FLOAT, NUMBER);
        TOKEN_MAP.put(JsonToken.VALUE_NULL, NULL);
        TOKEN_MAP.put(JsonToken.START_OBJECT, OBJECT);
        TOKEN_MAP.put(JsonToken.VALUE_STRING, STRING);
        HashMap<String, NodeType> builder = new HashMap<String, NodeType>();
        for (NodeType type2 : NodeType.values()) {
            builder.put(type2.name, type2);
        }
        NAME_MAP = Collections.unmodifiableMap(builder);
    }
}

