/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jackson.jsonpointer.ReferenceToken;
import com.github.fge.jackson.jsonpointer.TokenResolver;
import com.github.fge.jsonpatch.Iterables;
import com.github.fge.jsonpatch.JsonPatchException;
import com.github.fge.jsonpatch.PathValueOperation;

public final class AddOperation
extends PathValueOperation {
    private static final ReferenceToken LAST_ARRAY_ELEMENT = ReferenceToken.fromRaw("-");

    @JsonCreator
    public AddOperation(@JsonProperty(value="path") JsonPointer path2, @JsonProperty(value="value") JsonNode value2) {
        super("add", path2, value2);
    }

    @Override
    public JsonNode apply(JsonNode node) throws JsonPatchException {
        if (this.path.isEmpty()) {
            return this.value;
        }
        JsonNode parentNode = this.path.parent().path(node);
        if (parentNode.isMissingNode()) {
            throw new JsonPatchException(BUNDLE.getMessage("jsonPatch.noSuchParent"));
        }
        if (!parentNode.isContainerNode()) {
            throw new JsonPatchException(BUNDLE.getMessage("jsonPatch.parentNotContainer"));
        }
        return parentNode.isArray() ? this.addToArray(this.path, node) : this.addToObject(this.path, node);
    }

    private JsonNode addToArray(JsonPointer path2, JsonNode node) throws JsonPatchException {
        int index;
        Object ret = node.deepCopy();
        ArrayNode target = (ArrayNode)path2.parent().get(ret);
        TokenResolver<JsonNode> token2 = Iterables.getLast(path2);
        if (token2.getToken().equals(LAST_ARRAY_ELEMENT)) {
            target.add(this.value);
            return ret;
        }
        int size2 = target.size();
        try {
            index = Integer.parseInt(token2.toString());
        }
        catch (NumberFormatException ignored) {
            throw new JsonPatchException(BUNDLE.getMessage("jsonPatch.notAnIndex"));
        }
        if (index < 0 || index > size2) {
            throw new JsonPatchException(BUNDLE.getMessage("jsonPatch.noSuchIndex"));
        }
        target.insert(index, this.value);
        return ret;
    }

    private JsonNode addToObject(JsonPointer path2, JsonNode node) {
        TokenResolver<JsonNode> token2 = Iterables.getLast(path2);
        Object ret = node.deepCopy();
        ObjectNode target = (ObjectNode)path2.parent().get(ret);
        target.set(token2.getToken().getRaw(), this.value);
        return ret;
    }
}

