/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonpatch.Iterables;
import com.github.fge.jsonpatch.JsonPatchException;
import com.github.fge.jsonpatch.JsonPatchOperation;
import java.io.IOException;

public final class RemoveOperation
extends JsonPatchOperation {
    @JsonCreator
    public RemoveOperation(@JsonProperty(value="path") JsonPointer path2) {
        super("remove", path2);
    }

    @Override
    public JsonNode apply(JsonNode node) throws JsonPatchException {
        if (this.path.isEmpty()) {
            return MissingNode.getInstance();
        }
        if (this.path.path(node).isMissingNode()) {
            throw new JsonPatchException(BUNDLE.getMessage("jsonPatch.noSuchPath"));
        }
        Object ret = node.deepCopy();
        JsonNode parentNode = (JsonNode)this.path.parent().get(ret);
        String raw = Iterables.getLast(this.path).getToken().getRaw();
        if (parentNode.isObject()) {
            ((ObjectNode)parentNode).remove(raw);
        } else {
            ((ArrayNode)parentNode).remove(Integer.parseInt(raw));
        }
        return ret;
    }

    @Override
    public void serialize(JsonGenerator jgen, SerializerProvider provider2) throws IOException, JsonProcessingException {
        jgen.writeStartObject();
        jgen.writeStringField("op", "remove");
        jgen.writeStringField("path", this.path.toString());
        jgen.writeEndObject();
    }

    @Override
    public void serializeWithType(JsonGenerator jgen, SerializerProvider provider2, TypeSerializer typeSer) throws IOException, JsonProcessingException {
        this.serialize(jgen, provider2);
    }

    @Override
    public String toString() {
        return "op: " + this.op + "; path: \"" + this.path + '\"';
    }
}

