/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonpatch.Iterables;
import com.github.fge.jsonpatch.JsonPatchException;
import com.github.fge.jsonpatch.PathValueOperation;

public final class ReplaceOperation
extends PathValueOperation {
    @JsonCreator
    public ReplaceOperation(@JsonProperty(value="path") JsonPointer path2, @JsonProperty(value="value") JsonNode value2) {
        super("replace", path2, value2);
    }

    @Override
    public JsonNode apply(JsonNode node) throws JsonPatchException {
        if (this.path.path(node).isMissingNode()) {
            throw new JsonPatchException(BUNDLE.getMessage("jsonPatch.noSuchPath"));
        }
        Object replacement = this.value.deepCopy();
        if (this.path.isEmpty()) {
            return replacement;
        }
        Object ret = node.deepCopy();
        JsonNode parent = (JsonNode)this.path.parent().get(ret);
        String rawToken = Iterables.getLast(this.path).getToken().getRaw();
        if (parent.isObject()) {
            ((ObjectNode)parent).replace(rawToken, (JsonNode)replacement);
        } else {
            ((ArrayNode)parent).set(Integer.parseInt(rawToken), (JsonNode)replacement);
        }
        return ret;
    }
}

