/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch.diff;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonpatch.AddOperation;
import com.github.fge.jsonpatch.CopyOperation;
import com.github.fge.jsonpatch.JsonPatchOperation;
import com.github.fge.jsonpatch.MoveOperation;
import com.github.fge.jsonpatch.RemoveOperation;
import com.github.fge.jsonpatch.ReplaceOperation;

final class DiffOperation {
    private final Type type;
    private final JsonPointer from;
    private final JsonNode oldValue;
    private final JsonPointer path;
    private final JsonNode value;

    static DiffOperation add(JsonPointer path2, JsonNode value2) {
        return new DiffOperation(Type.ADD, null, null, path2, value2);
    }

    static DiffOperation copy(JsonPointer from2, JsonPointer path2, JsonNode value2) {
        return new DiffOperation(Type.COPY, from2, null, path2, value2);
    }

    static DiffOperation move(JsonPointer from2, JsonNode oldValue, JsonPointer path2, JsonNode value2) {
        return new DiffOperation(Type.MOVE, from2, oldValue, path2, value2);
    }

    static DiffOperation remove(JsonPointer from2, JsonNode oldValue) {
        return new DiffOperation(Type.REMOVE, from2, oldValue, null, null);
    }

    static DiffOperation replace(JsonPointer from2, JsonNode oldValue, JsonNode value2) {
        return new DiffOperation(Type.REPLACE, from2, oldValue, null, value2);
    }

    private DiffOperation(Type type2, JsonPointer from2, JsonNode oldValue, JsonPointer path2, JsonNode value2) {
        this.type = type2;
        this.from = from2;
        this.oldValue = oldValue;
        this.path = path2;
        this.value = value2;
    }

    Type getType() {
        return this.type;
    }

    JsonPointer getFrom() {
        return this.from;
    }

    JsonNode getOldValue() {
        return this.oldValue;
    }

    JsonPointer getPath() {
        return this.path;
    }

    JsonNode getValue() {
        return this.value;
    }

    JsonPatchOperation asJsonPatchOperation() {
        return this.type.toOperation(this);
    }

    static enum Type {
        ADD{

            @Override
            JsonPatchOperation toOperation(DiffOperation op) {
                return new AddOperation(op.path, op.value);
            }
        }
        ,
        COPY{

            @Override
            JsonPatchOperation toOperation(DiffOperation op) {
                return new CopyOperation(op.from, op.path);
            }
        }
        ,
        MOVE{

            @Override
            JsonPatchOperation toOperation(DiffOperation op) {
                return new MoveOperation(op.from, op.path);
            }
        }
        ,
        REMOVE{

            @Override
            JsonPatchOperation toOperation(DiffOperation op) {
                return new RemoveOperation(op.from);
            }
        }
        ,
        REPLACE{

            @Override
            JsonPatchOperation toOperation(DiffOperation op) {
                return new ReplaceOperation(op.from, op.value);
            }
        };


        abstract JsonPatchOperation toOperation(DiffOperation var1);
    }
}

