/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch.diff;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonNumEquals;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchOperation;
import com.github.fge.jsonpatch.diff.DiffOperation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

final class DiffProcessor {
    private static final JsonNumEquals EQUIVALENCE = JsonNumEquals.getInstance();
    private final Map<JsonPointer, JsonNode> unchanged;
    private final List<DiffOperation> diffs = new ArrayList<DiffOperation>();

    DiffProcessor(Map<JsonPointer, JsonNode> unchanged) {
        this.unchanged = Collections.unmodifiableMap(new HashMap<JsonPointer, JsonNode>(unchanged));
    }

    void valueReplaced(JsonPointer pointer, JsonNode oldValue, JsonNode newValue) {
        this.diffs.add(DiffOperation.replace(pointer, oldValue, newValue));
    }

    void valueRemoved(JsonPointer pointer, JsonNode value2) {
        this.diffs.add(DiffOperation.remove(pointer, value2));
    }

    void valueAdded(JsonPointer pointer, JsonNode value2) {
        int removalIndex = this.findPreviouslyRemoved(value2);
        if (removalIndex != -1) {
            DiffOperation removed = this.diffs.get(removalIndex);
            this.diffs.remove(removalIndex);
            this.diffs.add(DiffOperation.move(removed.getFrom(), value2, pointer, value2));
            return;
        }
        JsonPointer ptr = this.findUnchangedValue(value2);
        DiffOperation op = ptr != null ? DiffOperation.copy(ptr, pointer, value2) : DiffOperation.add(pointer, value2);
        this.diffs.add(op);
    }

    JsonPatch getPatch() {
        ArrayList<JsonPatchOperation> list = new ArrayList<JsonPatchOperation>();
        for (DiffOperation op : this.diffs) {
            list.add(op.asJsonPatchOperation());
        }
        return new JsonPatch(list);
    }

    @Nullable
    private JsonPointer findUnchangedValue(JsonNode value2) {
        for (Map.Entry<JsonPointer, JsonNode> entry : this.unchanged.entrySet()) {
            if (!EQUIVALENCE.equivalent(value2, entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    private int findPreviouslyRemoved(JsonNode value2) {
        for (int i2 = 0; i2 < this.diffs.size(); ++i2) {
            DiffOperation op = this.diffs.get(i2);
            if (op.getType() != DiffOperation.Type.REMOVE || !EQUIVALENCE.equivalent(value2, op.getOldValue())) continue;
            return i2;
        }
        return -1;
    }
}

