/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch.diff;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.JacksonUtils;
import com.github.fge.jackson.JsonNumEquals;
import com.github.fge.jackson.NodeType;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchMessages;
import com.github.fge.jsonpatch.diff.DiffProcessor;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.load.MessageBundles;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class JsonDiff {
    private static final MessageBundle BUNDLE = MessageBundles.getBundle(JsonPatchMessages.class);
    private static final ObjectMapper MAPPER = JacksonUtils.newMapper();
    private static final JsonNumEquals EQUIVALENCE = JsonNumEquals.getInstance();

    private JsonDiff() {
    }

    public static JsonPatch asJsonPatch(JsonNode source2, JsonNode target) {
        BUNDLE.checkNotNull(source2, "common.nullArgument");
        BUNDLE.checkNotNull(target, "common.nullArgument");
        Map<JsonPointer, JsonNode> unchanged = JsonDiff.getUnchangedValues(source2, target);
        DiffProcessor processor = new DiffProcessor(unchanged);
        JsonDiff.generateDiffs(processor, JsonPointer.empty(), source2, target);
        return processor.getPatch();
    }

    public static JsonNode asJson(JsonNode source2, JsonNode target) {
        try {
            String s2 = MAPPER.writeValueAsString(JsonDiff.asJsonPatch(source2, target));
            return MAPPER.readTree(s2);
        }
        catch (IOException e2) {
            throw new RuntimeException("cannot generate JSON diff", e2);
        }
    }

    private static void generateDiffs(DiffProcessor processor, JsonPointer pointer, JsonNode source2, JsonNode target) {
        NodeType secondType;
        if (EQUIVALENCE.equivalent(source2, target)) {
            return;
        }
        NodeType firstType = NodeType.getNodeType(source2);
        if (firstType != (secondType = NodeType.getNodeType(target))) {
            processor.valueReplaced(pointer, source2, target);
            return;
        }
        if (!source2.isContainerNode()) {
            processor.valueReplaced(pointer, source2, target);
            return;
        }
        if (firstType == NodeType.OBJECT) {
            JsonDiff.generateObjectDiffs(processor, pointer, (ObjectNode)source2, (ObjectNode)target);
        } else {
            JsonDiff.generateArrayDiffs(processor, pointer, (ArrayNode)source2, (ArrayNode)target);
        }
    }

    private static void generateObjectDiffs(DiffProcessor processor, JsonPointer pointer, ObjectNode source2, ObjectNode target) {
        Set<String> firstFields = JsonDiff.collect(source2.fieldNames(), new TreeSet());
        Set<String> secondFields = JsonDiff.collect(target.fieldNames(), new TreeSet());
        HashSet<String> copy1 = new HashSet<String>(firstFields);
        copy1.removeAll(secondFields);
        for (String string : Collections.unmodifiableSet(copy1)) {
            processor.valueRemoved(pointer.append(string), source2.get(string));
        }
        HashSet<String> copy2 = new HashSet<String>(secondFields);
        copy2.removeAll(firstFields);
        for (String field : Collections.unmodifiableSet(copy2)) {
            processor.valueAdded(pointer.append(field), target.get(field));
        }
        HashSet<String> hashSet = new HashSet<String>(firstFields);
        hashSet.retainAll(secondFields);
        for (String field : hashSet) {
            JsonDiff.generateDiffs(processor, pointer.append(field), source2.get(field), target.get(field));
        }
    }

    private static <T> Set<T> collect(Iterator<T> from2, Set<T> to) {
        if (from2 == null) {
            throw new NullPointerException();
        }
        if (to == null) {
            throw new NullPointerException();
        }
        while (from2.hasNext()) {
            to.add(from2.next());
        }
        return Collections.unmodifiableSet(to);
    }

    private static void generateArrayDiffs(DiffProcessor processor, JsonPointer pointer, ArrayNode source2, ArrayNode target) {
        int size2;
        int index;
        int firstSize = source2.size();
        int secondSize = target.size();
        for (index = size2 = Math.min(firstSize, secondSize); index < firstSize; ++index) {
            processor.valueRemoved(pointer.append(size2), source2.get(index));
        }
        for (index = 0; index < size2; ++index) {
            JsonDiff.generateDiffs(processor, pointer.append(index), source2.get(index), target.get(index));
        }
        for (index = size2; index < secondSize; ++index) {
            processor.valueAdded(pointer.append("-"), target.get(index));
        }
    }

    static Map<JsonPointer, JsonNode> getUnchangedValues(JsonNode source2, JsonNode target) {
        HashMap<JsonPointer, JsonNode> ret = new HashMap<JsonPointer, JsonNode>();
        JsonDiff.computeUnchanged(ret, JsonPointer.empty(), source2, target);
        return ret;
    }

    private static void computeUnchanged(Map<JsonPointer, JsonNode> ret, JsonPointer pointer, JsonNode first2, JsonNode second2) {
        NodeType secondType;
        if (EQUIVALENCE.equivalent(first2, second2)) {
            ret.put(pointer, second2);
            return;
        }
        NodeType firstType = NodeType.getNodeType(first2);
        if (firstType != (secondType = NodeType.getNodeType(second2))) {
            return;
        }
        switch (firstType) {
            case OBJECT: {
                JsonDiff.computeObject(ret, pointer, first2, second2);
                break;
            }
            case ARRAY: {
                JsonDiff.computeArray(ret, pointer, first2, second2);
                break;
            }
        }
    }

    private static void computeObject(Map<JsonPointer, JsonNode> ret, JsonPointer pointer, JsonNode source2, JsonNode target) {
        Iterator<String> firstFields = source2.fieldNames();
        while (firstFields.hasNext()) {
            String name = firstFields.next();
            if (!target.has(name)) continue;
            JsonDiff.computeUnchanged(ret, pointer.append(name), source2.get(name), target.get(name));
        }
    }

    private static void computeArray(Map<JsonPointer, JsonNode> ret, JsonPointer pointer, JsonNode source2, JsonNode target) {
        int size2 = Math.min(source2.size(), target.size());
        for (int i2 = 0; i2 < size2; ++i2) {
            JsonDiff.computeUnchanged(ret, pointer.append(i2), source2.get(i2), target.get(i2));
        }
    }
}

