/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonLoader;
import java.io.IOException;
import java.net.URI;
import java.net.URL;

public enum SchemaVersion {
    DRAFTV4("http://json-schema.org/draft-04/schema#", "/draftv4/schema"),
    DRAFTV3("http://json-schema.org/draft-03/schema#", "/draftv3/schema"),
    DRAFTV4_HYPERSCHEMA("http://json-schema.org/draft-04/hyper-schema#", "/draftv4/hyper-schema");

    private final URI location;
    private final JsonNode schema;

    private SchemaVersion(String uri2, String resource2) {
        try {
            this.location = URI.create(uri2);
            URL url2 = SchemaVersion.class.getResource(resource2);
            this.schema = JsonLoader.fromURL(url2);
        }
        catch (IOException e2) {
            throw new ExceptionInInitializerError(e2);
        }
    }

    public URI getLocation() {
        return this.location;
    }

    public JsonNode getSchema() {
        return this.schema.deepCopy();
    }
}

