/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.core.keyword.syntax.checkers.draftv3;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.NodeType;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.keyword.syntax.checkers.SyntaxChecker;
import com.github.fge.jsonschema.core.keyword.syntax.checkers.helpers.DependenciesSyntaxChecker;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.core.tree.SchemaTree;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.google.common.base.Equivalence;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.HashSet;

public final class DraftV3DependenciesSyntaxChecker
extends DependenciesSyntaxChecker {
    private static final SyntaxChecker INSTANCE = new DraftV3DependenciesSyntaxChecker();

    public static SyntaxChecker getInstance() {
        return INSTANCE;
    }

    private DraftV3DependenciesSyntaxChecker() {
        super(NodeType.ARRAY, NodeType.STRING);
    }

    @Override
    protected void checkDependency(ProcessingReport report, MessageBundle bundle, String name, SchemaTree tree) throws ProcessingException {
        JsonNode node = this.getNode(tree).get(name);
        NodeType type2 = NodeType.getNodeType(node);
        if (type2 == NodeType.STRING) {
            return;
        }
        if (type2 != NodeType.ARRAY) {
            report.error(this.newMsg(tree, bundle, "common.dependencies.value.incorrectType").putArgument("property", name).putArgument("expected", this.dependencyTypes).putArgument("found", type2));
            return;
        }
        int size2 = node.size();
        if (size2 == 0) {
            report.warn(this.newMsg(tree, bundle, "common.array.empty").put("property", name));
            return;
        }
        HashSet<Equivalence.Wrapper<JsonNode>> set2 = Sets.newHashSet();
        boolean uniqueElements = true;
        for (int index = 0; index < size2; ++index) {
            JsonNode element = node.get(index);
            type2 = NodeType.getNodeType(element);
            uniqueElements = set2.add(EQUIVALENCE.wrap(element));
            if (type2 == NodeType.STRING) continue;
            report.error(this.newMsg(tree, bundle, "common.array.element.incorrectType").put("property", name).putArgument("index", index).putArgument("expected", EnumSet.of(NodeType.STRING)).putArgument("found", type2));
        }
        if (!uniqueElements) {
            report.warn(this.newMsg(tree, bundle, "common.array.duplicateElements").put("property", name));
        }
    }
}

