/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.core.keyword.syntax.checkers.helpers;

import com.github.fge.jackson.NodeType;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.keyword.syntax.checkers.AbstractSyntaxChecker;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.core.tree.SchemaTree;
import com.github.fge.msgsimple.bundle.MessageBundle;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;

public final class URISyntaxChecker
extends AbstractSyntaxChecker {
    public URISyntaxChecker(String keyword) {
        super(keyword, NodeType.STRING, new NodeType[0]);
    }

    @Override
    protected void checkValue(Collection<JsonPointer> pointers, MessageBundle bundle, ProcessingReport report, SchemaTree tree) throws ProcessingException {
        String s2 = this.getNode(tree).textValue();
        try {
            URI uri2 = new URI(s2);
            if (!uri2.equals(uri2.normalize())) {
                report.error(this.newMsg(tree, bundle, "common.uri.notNormalized").putArgument("value", s2));
            }
        }
        catch (URISyntaxException ignored) {
            report.error(this.newMsg(tree, bundle, "common.uri.invalid").putArgument("value", s2));
        }
    }
}

